<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ver Inventario</title>
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <style>
        /* Estilo para la fila en modo edición */
        .fila-edicion { background-color: #fffbe6 !important; }
        /* Estilo para resaltar el campo de stock */
        .stock-editable { font-weight: bold; color: #0d6efd; }
        .stock-input { border: 2px solid #0d6efd; font-weight: bold; }
    </style>
</head>
<body>
    <?php require_once 'sucursal.php'; ?>
    <div class="container mt-4">
        <div class="card">
            <div class="card-header">
    <div class="d-flex justify-content-between align-items-center">
        <div>
            <h3>Inventario Actual</h3>
            <p class="mb-0">Sucursal: <strong><?php echo NOMBRE_SUCURSAL_ACTIVA; ?></strong></p>
        </div>
        <div>
            <a href="index.php" class="btn btn-primary">Regresar a Lotes</a>
        </div>
    </div>
</div>
            <div class="card-body">
                <div class="mb-3">
                    <input type="text" id="buscador_inventario" class="form-control" placeholder="Buscar en el inventario...">
                </div>
                <div class="table-responsive">
                    <table class="table table-striped table-hover">
                        <thead class="table-dark">
                            <tr>
                                <th>Producto / Laboratorio</th>
                                <th>Códigos</th>
                                <th>Lote / Vencimiento</th>
                                <th>Factura</th>
                                <th>Stock</th>
                                <th>Acciones</th> </tr>
                        </thead>
                        <tbody id="tabla_inventario_body">
                            </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <script src="assets/js/jquery.min.js"></script>
    <script src="assets/js/ver_inventario.js"></script>
</body>
</html>