<?php
header('Content-Type: application/json');
require_once 'config.php';

$respuesta = ['status' => 'error', 'message' => 'Datos inválidos o faltantes.'];

// ================== 'usuario_recibe_id' ELIMINADO DEL IF ==================
if (isset($_POST['producto_id'], $_POST['cantidad'], $_POST['presentacion'], $_POST['sucursal_destino_id'], $_POST['usuario_envia_id'], $_POST['sefactura'])) {
    
    // Recolectar y sanitizar datos
    $producto_id     = filter_var($_POST['producto_id'], FILTER_VALIDATE_INT);
    $cantidad        = filter_var($_POST['cantidad'], FILTER_VALIDATE_INT);
    $presentacion    = filter_var($_POST['presentacion'], FILTER_UNSAFE_RAW);
    $sefactura = filter_var($_POST['sefactura'], FILTER_VALIDATE_INT); // 1 ó 0
    $sucursal_origen_id = ID_SUCURSAL_ACTUAL; 
    $sucursal_destino_id = filter_var($_POST['sucursal_destino_id'], FILTER_VALIDATE_INT);
    $usuario_envia_id    = filter_var($_POST['usuario_envia_id'], FILTER_VALIDATE_INT);
    // ================== LÍNEA ELIMINADA ==================
    // $usuario_recibe_id   = filter_var($_POST['usuario_recibe_id'], FILTER_VALIDATE_INT);

    // ================== VALIDACIÓN ACTUALIZADA ==================
    if ($producto_id && $cantidad > 0 && $sucursal_destino_id && $usuario_envia_id) {
        
        // Mapear presentación a las columnas de la BD (sin cambios)
        $c_unidad = 0;
        $c_blister = 0;
        $c_caja = 0;
        switch ($presentacion) {
            case 'UNIDAD': $c_unidad = $cantidad; break;
            case 'BLISTER': $c_blister = $cantidad; break;
            case 'CAJA': default: $c_caja = $cantidad; break;
        }

        try {
            $pdo->beginTransaction(); // Iniciar transacción

            // 1. Insertar en la tabla 'traslados' (el registro maestro)
            // ================== CONSULTA Y EXECUTE MODIFICADOS ==================
            // 'usuario_receptor_id' se inserta como NULL, ya que se definirá en la recepción.
            $sql_traslado = "INSERT INTO traslados 
                                (fecha_traslado, sucursal_origen, sucursal_destino, usuario_id, usuario_receptor_id, estado) 
                            VALUES (NOW(), ?, ?, ?, NULL, 'en_transito')";
            
            $stmt_traslado = $pdo->prepare($sql_traslado);
            // Se eliminó $usuario_recibe_id del execute
            $stmt_traslado->execute([$sucursal_origen_id, $sucursal_destino_id, $usuario_envia_id]);
            // =================================================================
            
            $traslado_id = $pdo->lastInsertId();

            // 2. Insertar en la tabla 'detalle_traslados' (el producto)
            $sql_detalle = "INSERT INTO detalle_traslados 
                                (traslado_id, producto_id, cantidad_unidad, cantidad_blister, cantidad_caja, sefactura) 
                            VALUES (?, ?, ?, ?, ?, ?)";
            
            $stmt_detalle = $pdo->prepare($sql_detalle);
            $stmt_detalle->execute([$traslado_id, $producto_id, $c_unidad, $c_blister, $c_caja, $sefactura]);

            if ($stmt_detalle->rowCount() > 0) {
                $pdo->commit(); // Confirmar los cambios
                $respuesta['status'] = 'success';
                $respuesta['message'] = '¡Traslado registrado correctamente!';
            } else {
                $pdo->rollBack(); // Revertir
                $respuesta['message'] = 'No se pudo registrar el detalle del traslado.';
            }

        } catch (PDOException $e) {
            $pdo->rollBack(); // Revertir en caso de error
            $respuesta['message'] = 'Error de base de datos: ' . $e->getMessage();
        }
    } else {
        $respuesta['message'] = 'Faltan datos obligatorios.';
    }
}

echo json_encode($respuesta);
?>