<?php
header('Content-Type: application/json');
require_once 'config.php';

// Recibimos solo los arrays que el JS nos envía
$sucursales = $_POST['sucursales'] ?? [];
$usuarios_envian = $_POST['usuariosEnvian'] ?? [];

// --- Lógica de Paginación ---
$pagina = isset($_POST['pagina']) ? (int)$_POST['pagina'] : 1;
$termino = isset($_POST['termino']) ? trim($_POST['termino']) : '';
$limit = 15;
$offset = ($pagina - 1) * $limit;

$respuesta = ['tabla' => '', 'paginacion' => ''];

// --- Función interna para construir selects ---
function construirSelectHTML($items, $name) {
    $html = "<select class='form-select form-select-sm' name='$name'>";
    foreach ($items as $item) {
        $html .= "<option value='{$item['id']}'>{$item['nombre']}</option>";
    }
    $html .= "</select>";
    return $html;
}

try {
    // --- BLOQUE DE CONSULTA ---
    $params = []; 
    $base_sql = "FROM productos ";
    $where_sql = '';
    $where_conditions = []; 

    if (!empty($termino)) {
        $palabras = explode(' ', $termino);
        foreach ($palabras as $key => $palabra) {
            if (!empty($palabra)) {
                $param_name = ":palabra" . $key; 
                $where_conditions[] = "CONCAT_WS(' ', NombreComercial, laboratorio, CodigoInterno, CodigoBarra) LIKE $param_name";
                $params[$param_name] = "%" . $palabra . "%";
            }
        }
        if (!empty($where_conditions)) {
            $where_sql = "WHERE " . implode(' AND ', $where_conditions);
        }
    }
    
    // --- 1. Contar resultados para paginación ---
    $count_sql = "SELECT COUNT(id) " . $base_sql . $where_sql;
    $count_stmt = $pdo->prepare($count_sql);
    $count_stmt->execute($params); 
    $total_resultados = $count_stmt->fetchColumn();
    $total_paginas = ceil($total_resultados / $limit);

    // --- 2. Obtener los productos de la página actual ---
    $sql = "SELECT id, NombreComercial, laboratorio " . $base_sql . $where_sql . " ORDER BY NombreComercial ASC LIMIT :limit OFFSET :offset";
    
    $stmt = $pdo->prepare($sql);

    // 3. Vinculamos los parámetros de búsqueda (como STRINGS)
    foreach ($params as $param_name => $value) {
        $stmt->bindValue($param_name, $value, PDO::PARAM_STR);
    }

    // 4. Vinculamos :limit y :offset explícitamente como INTEGERS
    $stmt->bindValue(':limit', (int) $limit, PDO::PARAM_INT);
    $stmt->bindValue(':offset', (int) $offset, PDO::PARAM_INT);
    
    $stmt->execute();
    $productos = $stmt->fetchAll(PDO::FETCH_ASSOC);
    // --- FIN DEL BLOQUE DE CONSULTA ---
    
    $html_tabla = '';
    if ($productos) {
        // Construimos los dropdowns UNA SOLA VEZ
        $select_sucursales = construirSelectHTML($sucursales, 'sucursal_destino');
        $select_envia = construirSelectHTML($usuarios_envian, 'usuario_envia');
        
        foreach ($productos as $producto) {
            $html_tabla .= "<tr id='fila-{$producto['id']}'>";
            $html_tabla .= "<td><strong>{$producto['NombreComercial']}</strong><br><small class='text-muted'>{$producto['laboratorio']}</small></td>";
            $html_tabla .= "<td><select class='form-select form-select-sm' name='presentacion'><option value='CAJA'>Caja</option><option value='BLISTER'>Blíster</option><option value='UNIDAD'>Unidad</option></select></td>";
            $html_tabla .= "<td><input type='number' class='form-control form-control-sm' name='cantidad' min='1' value='1'></td>";
            $html_tabla .= "<td><div class='form-check form-switch'><input class='form-check-input' type='checkbox' name='sefactura' checked></div></td>";
            $html_tabla .= "<td>{$select_sucursales}</td>";
            $html_tabla .= "<td>{$select_envia}</td>";
            $html_tabla .= "<td><button class='btn btn-info btn-sm w-100 btn-trasladar' data-id='{$producto['id']}'>Trasladar</button></td>";
            $html_tabla .= "</tr>";
        }
    } else {
        // Colspan 7
        $html_tabla = "<tr><td colspan='7' class='text-center'>No se encontraron productos para tu búsqueda.</td></tr>";
    }
    $respuesta['tabla'] = $html_tabla;

    // --- Generar HTML de la paginación ---
    if ($total_paginas > 1) {
        $html_paginacion = '<nav><ul class="pagination">';
        $html_paginacion .= ($pagina > 1) ? "<li class='page-item'><a class='page-link page-link-traslado' href='#' data-pagina='" . ($pagina - 1) . "'>&laquo;</a></li>" : "<li class='page-item disabled'><span class='page-link'>&laquo;</span></li>";
        
        $rango_inicio = max(1, $pagina - 2);
        $rango_fin = min($total_paginas, $pagina + 1);

        if ($rango_inicio > 1) { $html_paginacion .= "<li class='page-item'><a class='page-link page-link-traslado' href='#' data-pagina='1'>1</a></li><li class='page-item disabled'><span class='page-link'>...</span></li>"; }
        
        for ($i = $rango_inicio; $i <= $rango_fin; $i++) {
            $clase_activa = ($i == $pagina) ? ' active' : '';
            $html_paginacion .= "<li class='page-item{$clase_activa}'><a class='page-link page-link-traslado' href='#' data-pagina='$i'>$i</a></li>";
        }
        
        if ($rango_fin < $total_paginas) { $html_paginacion .= "<li class='page-item disabled'><span class='page-link'>...</span></li><li class='page-item'><a class='page-link page-link-traslado' href='#' data-pagina='$total_paginas'>$total_paginas</a></li>"; }
        
        $html_paginacion .= ($pagina < $total_paginas) ? "<li class='page-item'><a class='page-link page-link-traslado' href='#' data-pagina='" . ($pagina + 1) . "'>&raquo;</a></li>" : "<li class='page-item disabled'><span class='page-link'>&raquo;</span></li>";
        $html_paginacion .= '</ul></nav>';
        
        $respuesta['paginacion'] = $html_paginacion;
    }

} catch (PDOException $e) {
    // Colspan 7
    $respuesta['tabla'] = "<tr><td colspan='7' class='text-center text-danger'>Error de Base de Datos: " . $e->getMessage() . "</td></tr>";
}

echo json_encode($respuesta);
?>