$(document).ready(function() {
    
    /**
     * Carga la lista de ingresos recientes en su tabla correspondiente.
     */
    function cargarIngresosRecientes() {
        const tablaIngresos = $('#tabla_ingresos_recientes');

        $.ajax({
            type: 'GET',
            url: 'php/listar_ingresos_recientes.php',
            beforeSend: function() {
                // =============================================
                //          COLSPAN ACTUALIZADO A 8
                // =============================================
                tablaIngresos.html("<tr><td colspan='8' class='text-center'><div class='spinner-border spinner-border-sm'></div> Cargando...</td></tr>");
            },
            success: function(response) {
                // =============================================
                //          COLSPAN ACTUALIZADO A 8
                // =============================================
                tablaIngresos.html(response || "<tr><td colspan='8' class='text-center'>No hay ingresos.</td></tr>");
            },
            error: function() {
                // =============================================
                //          COLSPAN ACTUALIZADO A 8
                // =============================================
                tablaIngresos.html("<tr><td colspan='8' class='text-center text-danger'>Error al cargar los ingresos.</td></tr>");
            }
        });
    }

    // Carga inicial de ingresos al abrir la página
    cargarIngresosRecientes();

    // Opcional: Refrescar la lista cada 30 segundos
    // setInterval(cargarIngresosRecientes, 30000);
});