<?php
header('Content-Type: application/json');
require_once 'config.php';

$respuesta = ['status' => 'error', 'message' => 'Datos inválidos o faltantes.'];

if (isset($_POST['producto_id'], $_POST['cantidad'], $_POST['presentacion'], $_POST['usuario_entrega'], $_POST['usuario_recibe'])) {
    
    // Recolectar y sanitizar datos
    $producto_id     = filter_var($_POST['producto_id'], FILTER_VALIDATE_INT);
    $lote_id         = filter_var($_POST['lote_id'], FILTER_VALIDATE_INT); // Puede ser 0
    $cantidad        = filter_var($_POST['cantidad'], FILTER_VALIDATE_INT);
    $presentacion    = filter_var($_POST['presentacion'], FILTER_SANITIZE_STRING);
    // El valor de 'sefactura' es 1 si el checkbox está marcado, 0 si no.
    $sefactura       = isset($_POST['sefactura']) && $_POST['sefactura'] == '1' ? 1 : 0;
    $usuario_entrega = filter_var($_POST['usuario_entrega'], FILTER_VALIDATE_INT);
    $usuario_recibe  = filter_var($_POST['usuario_recibe'], FILTER_VALIDATE_INT);
    $sucursal_id     = ID_SUCURSAL_ACTUAL;

    // Validar datos básicos
    if ($producto_id && $cantidad > 0 && $usuario_entrega && $usuario_recibe) {
        try {
            $pdo->beginTransaction(); // Iniciar transacción para asegurar consistencia

            // --- Lógica de Creación de Lote ---
            if ($lote_id === 0) {
                // Generar un código de lote único y una fecha de vencimiento por defecto
                $codigo_lote_nuevo = 'L' . $producto_id . '-' . date('Ymd');
                $vencimiento_nuevo = date('Y-m-d', strtotime('+2 years'));

                $sql_lote = "INSERT INTO lote (producto_id, sefactura, codigo_lote, fechavencimiento) VALUES (?, ?, ?, ?)";
                $stmt_lote = $pdo->prepare($sql_lote);
                $stmt_lote->execute([$producto_id, $sefactura, $codigo_lote_nuevo, $vencimiento_nuevo]);
                
                // Obtenemos el ID del lote que acabamos de crear
                $lote_id = $pdo->lastInsertId();
            } else {
                // Si el lote ya existe, simplemente actualizamos su estado 'sefactura'
                $sql_update_lote = "UPDATE lote SET sefactura = ? WHERE id = ?";
                $stmt_update = $pdo->prepare($sql_update_lote);
                $stmt_update->execute([$sefactura, $lote_id]);
            }

            // --- Registrar el Ingreso en Sucursal ---
            $sql_ingreso = "INSERT INTO ingresos_sucursal 
                                (producto_id, lote_id, sucursal_id, cantidad_ingresada, presentacion_ingresada, usuario_entrega_id, usuario_recibe_id) 
                            VALUES (?, ?, ?, ?, ?, ?, ?)";

            $stmt_ingreso = $pdo->prepare($sql_ingreso);
            $stmt_ingreso->execute([$producto_id, $lote_id, $sucursal_id, $cantidad, $presentacion, $usuario_entrega, $usuario_recibe]);

            if ($stmt_ingreso->rowCount() > 0) {
                $pdo->commit(); // Confirmar los cambios
                $respuesta['status'] = 'success';
                $respuesta['message'] = '¡Ingreso registrado correctamente!';
            } else {
                $pdo->rollBack(); // Revertir si algo falló
                $respuesta['message'] = 'No se pudo registrar el ingreso.';
            }

        } catch (PDOException $e) {
            $pdo->rollBack(); // Revertir en caso de error
            $respuesta['message'] = 'Error de base de datos: ' . $e->getMessage();
        }
    }
}

echo json_encode($respuesta);
?>