<?php
// --- CONFIGURACIÓN DE LA BASE DE DATOS ---
define('DB_HOST', 'localhost');
define('DB_USER', 'root');
define('DB_PASS', ''); // Sin contraseña, como solicitaste
define('DB_NAME', 'sufarma');

// --- CONFIGURACIÓN DE LA SUCURSAL ---
// Este es el ID de la sucursal actual. En un sistema real, esto
// provendría de la sesión del usuario que ha iniciado sesión.
define('ID_SUCURSAL_ACTUAL', 1); // Asegúrate que una sucursal con id=1 exista.

// Crear la conexión a la base de datos usando PDO
try {
    $pdo = new PDO("mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4", DB_USER, DB_PASS);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    // Detener la ejecución si la conexión falla
    die("ERROR: No se pudo conectar a la base de datos. " . $e->getMessage());
}

// Función para obtener todos los usuarios (para los selectores de entrega/recibe)
function obtenerUsuarios($pdo) {
    // Tu tabla `usuarios` tiene las columnas `id` y `nombre`
    $stmt = $pdo->query("SELECT id, nombre FROM usuarios ORDER BY nombre ASC");
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
}
?>