<?php
header('Content-Type: application/json');
require_once 'config.php';

// --- Lógica de Paginación ---
$pagina = isset($_POST['pagina']) ? (int)$_POST['pagina'] : 1;
$termino = isset($_POST['termino']) ? trim($_POST['termino']) : '';
$limit = 15;
$offset = ($pagina - 1) * $limit;

$respuesta = ['tabla' => '', 'paginacion' => ''];

try {
    // --- Construcción de la consulta y parámetros ---
    $params = []; // Un único array para todos los parámetros
    $base_sql = "FROM productos ";
    $where_sql = '';

    if (!empty($termino)) {
        $palabras = explode(' ', $termino);
        $where_conditions = [];
        foreach ($palabras as $palabra) {
            if (!empty($palabra)) {
                $where_conditions[] = "CONCAT_WS(' ', NombreComercial, laboratorio, CodigoInterno, CodigoBarra) LIKE ?";
                $params[] = "%" . $palabra . "%"; // Añadimos los parámetros de búsqueda
            }
        }
        if (!empty($where_conditions)) {
            $where_sql = "WHERE " . implode(' AND ', $where_conditions);
        }
    }
    
    // --- Contar resultados para paginación ---
    $count_sql = "SELECT COUNT(id) " . $base_sql . $where_sql;
    $count_stmt = $pdo->prepare($count_sql);
    $count_stmt->execute($params);
    $total_resultados = $count_stmt->fetchColumn();
    $total_paginas = ceil($total_resultados / $limit);

    // --- Obtener los productos de la página actual ---
    // **CORRECCIÓN CLAVE**: Usamos '?' para LIMIT y OFFSET también.
    $sql = "SELECT id, NombreComercial, laboratorio " . $base_sql . $where_sql . " ORDER BY NombreComercial ASC LIMIT ? OFFSET ?";
    
    // Añadimos los parámetros de paginación al final del array
    $params[] = $limit;
    $params[] = $offset;

    $stmt = $pdo->prepare($sql);

    // **CORRECCIÓN CLAVE**: Vinculamos todos los parámetros del array unificado
    $param_index = 1;
    foreach ($params as $value) {
        $type = is_int($value) ? PDO::PARAM_INT : PDO::PARAM_STR;
        $stmt->bindValue($param_index, $value, $type);
        $param_index++;
    }
    
    $stmt->execute();
    $productos = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // --- Generar HTML de la tabla (sin cambios en esta parte) ---
    $html_tabla = '';
    if ($productos) {
        $usuarios = obtenerUsuarios($pdo);
        foreach ($productos as $producto) {
            $lote_stmt = $pdo->prepare("SELECT id FROM lote WHERE producto_id = ? ORDER BY fechacreacion DESC LIMIT 1");
            $lote_stmt->execute([$producto['id']]);
            $lote_existente = $lote_stmt->fetch(PDO::FETCH_ASSOC);
            $lote_id_para_usar = $lote_existente ? $lote_existente['id'] : '0';

            $html_tabla .= "<tr id='fila-{$producto['id']}'>";
            $html_tabla .= "<td><strong>{$producto['NombreComercial']}</strong><br><small class='text-muted'>{$producto['laboratorio']}</small></td>";
            $html_tabla .= "<input type='hidden' name='lote_id' value='{$lote_id_para_usar}'>";
            $html_tabla .= "<td><select class='form-select form-select-sm' name='presentacion'><option value='CAJA'>Caja</option><option value='BLISTER'>Blíster</option><option value='UNIDAD'>Unidad</option></select></td>";
            $html_tabla .= "<td><input type='number' class='form-control form-control-sm' name='cantidad' min='1' value='1'></td>";
            $html_tabla .= "<td><div class='form-check form-switch'><input class='form-check-input' type='checkbox' name='sefactura' checked></div></td>";
            $html_tabla .= "<td><select class='form-select form-select-sm' name='usuario_entrega'>";
            foreach ($usuarios as $user) { $html_tabla .= "<option value='{$user['id']}'>{$user['nombre']}</option>"; }
            $html_tabla .= "</select></td>";
            $html_tabla .= "<td><select class='form-select form-select-sm' name='usuario_recibe'>";
            foreach ($usuarios as $user) { $html_tabla .= "<option value='{$user['id']}'>{$user['nombre']}</option>"; }
            $html_tabla .= "</select></td>";
            $html_tabla .= "<td><button class='btn btn-success btn-sm w-100 btn-guardar' data-id='{$producto['id']}'>Ingresar</button></td>";
            $html_tabla .= "</tr>";
        }
    } else {
        $html_tabla = "<tr><td colspan='7' class='text-center'>No se encontraron productos para tu búsqueda.</td></tr>";
    }
    $respuesta['tabla'] = $html_tabla;

    // --- Generar HTML de la paginación (sin cambios en esta parte) ---
    if ($total_paginas > 1) {
        $html_paginacion = '<nav><ul class="pagination">';
        $html_paginacion .= ($pagina > 1) ? "<li class='page-item'><a class='page-link' href='#' data-pagina='" . ($pagina - 1) . "'>&laquo;</a></li>" : "<li class='page-item disabled'><span class='page-link'>&laquo;</span></li>";
        
        $rango_inicio = max(1, $pagina - 2);
        $rango_fin = min($total_paginas, $pagina + 1);
        if ($rango_inicio > 1) { $html_paginacion .= "<li class='page-item'><a class='page-link' href='#' data-pagina='1'>1</a></li><li class='page-item disabled'><span class='page-link'>...</span></li>"; }
        for ($i = $rango_inicio; $i <= $rango_fin; $i++) {
            $clase_activa = ($i == $pagina) ? ' active' : '';
            $html_paginacion .= "<li class='page-item{$clase_activa}'><a class='page-link' href='#' data-pagina='$i'>$i</a></li>";
        }
        if ($rango_fin < $total_paginas) { $html_paginacion .= "<li class='page-item disabled'><span class='page-link'>...</span></li><li class='page-item'><a class='page-link' href='#' data-pagina='$total_paginas'>$total_paginas</a></li>"; }
        $html_paginacion .= ($pagina < $total_paginas) ? "<li class='page-item'><a class='page-link' href='#' data-pagina='" . ($pagina + 1) . "'>&raquo;</a></li>" : "<li class='page-item disabled'><span class='page-link'>&raquo;</span></li>";
        $html_paginacion .= '</ul></nav>';
        $respuesta['paginacion'] = $html_paginacion;
    }

} catch (PDOException $e) {
    $respuesta['tabla'] = "<tr><td colspan='7' class='text-center text-danger'>Error de Base de Datos: " . $e->getMessage() . "</td></tr>";
}

echo json_encode($respuesta);