<?php
require_once 'php/config.php';
$usuarios = obtenerUsuarios($pdo);
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ingreso de Medicamentos - Sufarma v3</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="icon" href="data:image/svg+xml,<svg xmlns=%22http://www.w3.org/2000/svg%22 viewBox=%220 0 100 100%22><text y=%22.9em%22 font-size=%2290%22>📦</text></svg>">
</head>
<body>

<nav class="navbar navbar-expand-lg navbar-dark bg-success shadow-sm">
    <div class="container">
        <a class="navbar-brand" href="#">Sufarma v3</a>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav">
                <li class="nav-item">
                    <a class="nav-link active" aria-current="page" href="index.php">Registrar Ingreso</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="ingresos.php">Ver Ingresos</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="https://sufarmasanfe.farmaciasjireh.com/index_simplificado.php">Regresar a Ventas</a>
                </li>
            </ul>
        </div>
    </div>
</nav>

<div class="container my-4">
    <div class="card shadow-sm">
        <div class="card-header bg-success text-white">
            <h3 class="mb-0">Registrar Ingreso de Productos</h3>
            
            <p class="mb-0">Sucursal de Trabajo: <?php echo NOMBRE_SUCURSAL_ACTUAL; ?></p>
            
        </div>
        <div class="card-body">
            <div class="input-group input-group-lg mb-3">
                <span class="input-group-text">🔍</span>
                <input type="text" id="caja_busqueda" class="form-control" placeholder="Buscar por Código, Nombre, Laboratorio..." autofocus>
            </div>

            <div class="table-responsive">
                <table class="table table-hover align-middle">
                    <thead class="table-light">
                        <tr>
                            <th>Producto / Laboratorio</th>
                            <th style="width: 12%;">Presentación</th>
                            <th style="width: 10%;">Cantidad</th>
                            <th style="width: 12%;">Vencimiento</th>
                            <th style="width: 10%;">Facturable</th>
                            <th style="width: 15%;">Entregado Por</th>
                            <th style="width: 15%;">Recibido Por</th>
                            <th style="width: 10%;">Acción</th>
                        </tr>
                    </thead>
                    <tbody id="tabla_resultados">
                        <tr><td colspan="8" class="text-center text-muted">Cargando productos...</td></tr>
                    </tbody>
                </table>
            </div>
            <div id="contenedor-paginacion" class="d-flex justify-content-center"></div>
        </div>
    </div>

    <div id="alerta-notificacion" class="alert alert-success d-none position-fixed bottom-0 end-0 m-3 shadow-lg" role="alert"></div>
</div>

<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="js/main.js"></script>

</body>
</html>