<?php
header('Content-Type: application/json');
require_once 'config.php';

$respuesta = ['status' => 'error', 'message' => 'Datos inválidos.'];
$data = json_decode(file_get_contents('php://input'), true);

if (isset($data['origen_id'], $data['destino_id'], $data['envia_id'], $data['recibe_id'], $data['productos']) && !empty($data['productos'])) {

    $origen_id = filter_var($data['origen_id'], FILTER_VALIDATE_INT);
    $destino_id = filter_var($data['destino_id'], FILTER_VALIDATE_INT);
    $envia_id = filter_var($data['envia_id'], FILTER_VALIDATE_INT);
    $recibe_id = filter_var($data['recibe_id'], FILTER_VALIDATE_INT);
    $productos = $data['productos'];

    if ($origen_id == $destino_id) {
        $respuesta['message'] = 'La sucursal de origen y destino no pueden ser la misma.';
        echo json_encode($respuesta);
        exit;
    }

    try {
        $pdo->beginTransaction();

        $sql_traslado = "INSERT INTO traslados (sucursal_origen, sucursal_destino, usuario_id, usuario_receptor_id, estado) VALUES (?, ?, ?, ?, 'pendiente')";
        $stmt_traslado = $pdo->prepare($sql_traslado);
        $stmt_traslado->execute([$origen_id, $destino_id, $envia_id, $recibe_id]);
        $traslado_id = $pdo->lastInsertId();

        // **CAMBIO 1: Actualizar la consulta para incluir la nueva columna `sefactura`**
        $sql_detalle = "INSERT INTO detalle_traslados (traslado_id, producto_id, cantidad_unidad, cantidad_blister, cantidad_caja, sefactura) VALUES (?, ?, ?, ?, ?, ?)";
        $stmt_detalle = $pdo->prepare($sql_detalle);

        foreach ($productos as $prod) {
            $producto_id = filter_var($prod['id'], FILTER_VALIDATE_INT);
            $cantidad = filter_var($prod['cantidad'], FILTER_VALIDATE_INT);
            $presentacion = $prod['presentacion'];
            // **CAMBIO 2: Leer el nuevo dato `sefactura`**
            $sefactura = isset($prod['sefactura']) && $prod['sefactura'] == 1 ? 1 : 0;
            
            $cant_unidad = ($presentacion === 'UNIDAD') ? $cantidad : 0;
            $cant_blister = ($presentacion === 'BLISTER') ? $cantidad : 0;
            $cant_caja = ($presentacion === 'CAJA') ? $cantidad : 0;
            
            // **CAMBIO 3: Añadir el nuevo dato al ejecutar la consulta**
            $stmt_detalle->execute([$traslado_id, $producto_id, $cant_unidad, $cant_blister, $cant_caja, $sefactura]);
        }

        $pdo->commit();
        $respuesta['status'] = 'success';
        $respuesta['message'] = '¡Traslado registrado con éxito con el ID: ' . $traslado_id . '!';

    } catch (PDOException $e) {
        $pdo->rollBack();
        $respuesta['message'] = 'Error de base de datos: ' . $e->getMessage();
    }
} else {
    $respuesta['message'] = 'Faltan datos o no se añadieron productos a la lista.';
}

echo json_encode($respuesta);