<?php
// --- CONFIGURACIÓN DE ZONA HORARIA ---
date_default_timezone_set('America/Guatemala');

// --- CONFIGURACIÓN DE LA BASE DE DATOS PARA TU HOSTING ---
define('DB_HOST', 'localhost');
define('DB_USER', 'root');
define('DB_PASS', '');
define('DB_NAME', 'sufarma');

// --- CONFIGURACIÓN DE LA SUCURSAL ---
// ID de la sucursal que siempre envía los traslados.
define('ID_SUCURSAL_ORIGEN_FIJA', 1); 

// Crear la conexión a la base de datos usando PDO
try {
    // Se usa 'utf8mb4' para una mejor compatibilidad con caracteres especiales
    $pdo = new PDO("mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4", DB_USER, DB_PASS);
    
    // Configurar PDO para que lance excepciones en caso de error
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

} catch (PDOException $e) {
    // Detener la ejecución si la conexión falla y mostrar un mensaje de error
    die("ERROR: No se pudo conectar a la base de datos. " . $e->getMessage());
}

/**
 * Función para obtener todos los usuarios del sistema.
 * @param PDO $pdo Objeto de la conexión a la base de datos.
 * @return array Lista de usuarios.
 */
function obtenerUsuarios($pdo) {
    try {
        $stmt = $pdo->query("SELECT id, nombre FROM usuarios ORDER BY nombre ASC");
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    } catch (PDOException $e) {
        // En caso de error, devolver un array vacío para no detener la ejecución.
        return [];
    }
}
?>