$(document).ready(function() {

    // Cargar sucursales y usuarios en los selects al iniciar
    function cargarDatosIniciales() {
        $.ajax({
            url: 'php/obtener_datos.php',
            type: 'GET',
            dataType: 'json',
            success: function(data) {
                const sucursalOrigen = $('#sucursal_origen');
                const sucursalDestino = $('#sucursal_destino');
                const usuarioEnvia = $('#usuario_envia');
                const usuarioRecibe = $('#usuario_recibe');
                const idOrigenFijo = data.sucursal_origen_fija;

                data.sucursales.forEach(s => {
                    if (s.id == idOrigenFijo) {
                        sucursalOrigen.append(new Option(s.nombre, s.id));
                    }
                    if (s.id != idOrigenFijo) {
                        sucursalDestino.append(new Option(s.nombre, s.id));
                    }
                });
                sucursalOrigen.prop('disabled', true);
                
                data.usuarios.forEach(u => {
                    usuarioEnvia.append(new Option(u.nombre, u.id));
                    usuarioRecibe.append(new Option(u.nombre, u.id));
                });
            }
        });
    }

    // Búsqueda de productos (sin cambios)
    $('#caja_busqueda').on('keyup', function() {
        let termino = $(this).val();
        let tablaResultados = $('#tabla_resultados_busqueda');
        if (termino.length < 2) { tablaResultados.empty(); return; }
        $.ajax({
            url: 'php/buscar_producto.php',
            type: 'POST',
            data: { termino: termino, pagina: 1 },
            dataType: 'json',
            success: function(response) {
                tablaResultados.empty();
                const productosHtml = $(response.tabla).map(function() {
                    const productoId = $(this).find('.btn-guardar').data('id');
                    const nombre = $(this).find('td:first-child').html();
                    if(productoId && nombre) {
                        return `<tr class="cursor-pointer" data-id="${productoId}" data-nombre="${$('<div>').html(nombre).text().trim()}"><td>${nombre}</td></tr>`;
                    }
                }).get().join('');
                tablaResultados.html(productosHtml);
            }
        });
    });

    // Añadir producto a la lista de traslado
    $('body').on('click', '#tabla_resultados_busqueda tr', function() {
        const productoId = $(this).data('id');
        const nombreProducto = $(this).data('nombre').replace('<br>', ' ');
        
        if ($(`#fila-traslado-${productoId}`).length > 0) {
            mostrarNotificacion('Este producto ya está en la lista.', 'warning');
            return;
        }

        $('#fila_vacia').remove();

        // **CAMBIO 1: Añadir el interruptor "Facturable" a la nueva fila**
        const nuevaFila = `
            <tr id="fila-traslado-${productoId}" data-id="${productoId}">
                <td>${nombreProducto}</td>
                <td>
                    <select class="form-select form-select-sm" name="presentacion">
                        <option value="CAJA">Caja</option>
                        <option value="BLISTER">Blíster</option>
                        <option value="UNIDAD">Unidad</option>
                    </select>
                </td>
                <td><input type="number" class="form-control form-control-sm" name="cantidad" min="1" value="1"></td>
                <td><div class="form-check form-switch"><input class="form-check-input" type="checkbox" name="sefactura" checked></div></td>
                <td><button class="btn btn-danger btn-sm btn-quitar">X</button></td>
            </tr>`;
        $('#tabla_productos_traslado').append(nuevaFila);
        $('#caja_busqueda').val('').focus();
        $('#tabla_resultados_busqueda').empty();
    });

    // Quitar producto de la lista (sin cambios)
    $('body').on('click', '.btn-quitar', function() {
        $(this).closest('tr').remove();
        if ($('#tabla_productos_traslado tr').length === 0) {
             $('#tabla_productos_traslado').html('<tr id="fila_vacia"><td colspan="5" class="text-center text-muted">Aún no has añadido productos.</td></tr>');
        }
    });

    // Guardar el traslado completo
    $('#btn_guardar_traslado').on('click', function() {
        const trasladoData = {
            origen_id: $('#sucursal_origen').val(),
            destino_id: $('#sucursal_destino').val(),
            envia_id: $('#usuario_envia').val(),
            recibe_id: $('#usuario_recibe').val(),
            productos: []
        };
        
        $('#tabla_productos_traslado tr').each(function() {
            const fila = $(this);
            if(fila.data('id')) {
                // **CAMBIO 2: Leer el estado del interruptor y añadirlo a los datos a enviar**
                const sefactura = fila.find('input[name="sefactura"]').is(':checked') ? 1 : 0;
                
                trasladoData.productos.push({
                    id: fila.data('id'),
                    cantidad: fila.find('input[name="cantidad"]').val(),
                    presentacion: fila.find('select[name="presentacion"]').val(),
                    sefactura: sefactura 
                });
            }
        });

        if (trasladoData.envia_id === trasladoData.recibe_id) {
            mostrarNotificacion('El usuario que envía no puede ser el mismo que recibe.', 'danger');
            return;
        }
        if (trasladoData.productos.length === 0) {
            mostrarNotificacion('Debes añadir al menos un producto al traslado.', 'danger');
            return;
        }

        $.ajax({
            url: 'php/guardar_traslado.php',
            type: 'POST',
            contentType: 'application/json',
            data: JSON.stringify(trasladoData),
            dataType: 'json',
            success: function(response) {
                mostrarNotificacion(response.message, response.status);
                if (response.status === 'success') {
                    setTimeout(() => window.location.reload(), 2000);
                }
            },
            error: function() {
                mostrarNotificacion('Error de conexión al guardar.', 'danger');
            }
        });
    });
    
    // Función de notificación (sin cambios)
    function mostrarNotificacion(mensaje, tipo = 'success') {
        const alerta = $('#alerta-notificacion');
        alerta.removeClass('alert-success alert-danger alert-warning d-none').addClass(`alert-${tipo === 'success' ? 'success' : 'danger'}`);
        alerta.text(mensaje).removeClass('d-none');
        setTimeout(() => alerta.addClass('d-none'), 4000);
    }
    
    // Carga inicial
    cargarDatosIniciales();
});