<?php
// update_sale.php
date_default_timezone_set('America/Guatemala'); // Ajusta la zona horaria según tu ubicación
include 'db_connection.php';
include 'sucursal_config.php';

// 1. Recibir datos por POST
$venta_id = isset($_POST['venta_id']) ? intval($_POST['venta_id']) : 0;
$cartJson = $_POST['cart'] ?? '[]';
$cart = json_decode($cartJson, true);

// Validar
if ($venta_id <= 0 || !is_array($cart) || count($cart) === 0) {
    echo json_encode([
        'success' => false,
        'message' => 'Datos inválidos.'
    ]);
    exit;
}

// Determinar si la venta es normal o especial
// Primero, comprobar si existe en ventas normales
$sqlCheckNormal = "SELECT id FROM ventas WHERE id = ? AND sucursal_id = ? LIMIT 1";
$stmtCheckN = $conn->prepare($sqlCheckNormal);
$stmtCheckN->bind_param("ii", $venta_id, $sucursal_id);
$stmtCheckN->execute();
$resCheckN = $stmtCheckN->get_result();

if ($resCheckN->num_rows > 0) {
    $tipoVenta = 'Normal';
} else {
    // Comprobar si existe en ventas especiales
    $sqlCheckEspecial = "SELECT id FROM ventas_especiales WHERE id = ? AND sucursal_id = ? LIMIT 1";
    $stmtCheckE = $conn->prepare($sqlCheckEspecial);
    $stmtCheckE->bind_param("ii", $venta_id, $sucursal_id);
    $stmtCheckE->execute();
    $resCheckE = $stmtCheckE->get_result();
    if ($resCheckE->num_rows > 0) {
        $tipoVenta = 'Especial';
    } else {
        echo json_encode([
            'success' => false,
            'message' => 'Venta no encontrada.'
        ]);
        exit;
    }
}

if ($tipoVenta === 'Normal') {
    // Actualizar la venta normal
    // Primero, actualizar el total en la tabla ventas
    $total = 0;
    foreach ($cart as $item) {
        $total += floatval($item['price']) * intval($item['quantity']);
    }

    $sqlUpdateVenta = "UPDATE ventas SET total = ? WHERE id = ? AND sucursal_id = ?";
    $stmtUpdateVenta = $conn->prepare($sqlUpdateVenta);
    $stmtUpdateVenta->bind_param("dii", $total, $venta_id, $sucursal_id);
    if (!$stmtUpdateVenta->execute()) {
        echo json_encode([
            'success' => false,
            'message' => 'Error al actualizar la venta: ' . $stmtUpdateVenta->error
        ]);
        exit;
    }

    // Eliminar los detalles existentes
    $sqlDeleteDetalle = "DELETE FROM detalle_ventas WHERE venta_id = ?";
    $stmtDeleteDetalle = $conn->prepare($sqlDeleteDetalle);
    $stmtDeleteDetalle->bind_param("i", $venta_id);
    if (!$stmtDeleteDetalle->execute()) {
        echo json_encode([
            'success' => false,
            'message' => 'Error al eliminar los detalles de la venta: ' . $stmtDeleteDetalle->error
        ]);
        exit;
    }

    // Insertar nuevos detalles
    foreach ($cart as $item) {
        $nombreComercial = $item['name']  ?? '';
        $laboratorio     = $item['lab']   ?? '';
        $precio          = floatval($item['price'] ?? 0);
        $cantidad        = intval($item['quantity'] ?? 1);
        $subtotal        = $precio * $cantidad;
        $facturado       = isset($item['facturar']) && $item['facturar'] ? 1 : 0;

        // Buscar el producto
        $sqlProd = "SELECT id FROM productos 
                    WHERE NombreComercial = ? AND laboratorio = ? 
                    LIMIT 1";
        $stmtProd = $conn->prepare($sqlProd);
        $stmtProd->bind_param("ss", $nombreComercial, $laboratorio);
        $stmtProd->execute();
        $resProd = $stmtProd->get_result();

        if ($resProd->num_rows > 0) {
            $prodData = $resProd->fetch_assoc();
            $productoId = $prodData['id'];

            // Insertar en detalle
            $sqlDet = "INSERT INTO detalle_ventas
                       (venta_id, producto_id, cantidad, precio, subtotal, facturado)
                       VALUES (?, ?, ?, ?, ?, ?)";
            $stmtDet = $conn->prepare($sqlDet);
            $stmtDet->bind_param("iiiddi", $venta_id, $productoId, $cantidad, $precio, $subtotal, $facturado);
            if (!$stmtDet->execute()) {
                echo json_encode([
                    'success' => false,
                    'message' => 'Error al insertar detalle de venta: ' . $stmtDet->error
                ]);
                exit;
            }
        }
    }

} elseif ($tipoVenta === 'Especial') {
    // Actualizar la venta especial
    if(count($cart) !== 1){
        echo json_encode([
            'success' => false,
            'message' => 'Las ventas especiales deben contener solo un ítem.'
        ]);
        exit;
    }

    $item = $cart[0];
    $descripcion = $item['name'];
    $precio = floatval($item['price']);

    // Actualizar la descripción y el precio
    $sqlUpdateEspecial = "UPDATE ventas_especiales SET descripcion = ?, precio = ? WHERE id = ? AND sucursal_id = ?";
    $stmtUpdateEspecial = $conn->prepare($sqlUpdateEspecial);
    $stmtUpdateEspecial->bind_param("sdii", $descripcion, $precio, $venta_id, $sucursal_id);
    if (!$stmtUpdateEspecial->execute()) {
        echo json_encode([
            'success' => false,
            'message' => 'Error al actualizar la venta especial: ' . $stmtUpdateEspecial->error
        ]);
        exit;
    }
}

// 3. Responder
echo json_encode([
    'success' => true,
    'message' => 'Venta actualizada exitosamente.'
]);
exit;
?>
