<?php
header('Content-Type: application/json');
require_once 'config.php';

// Mapa de asignación de usuarios a sucursales
$asignacion_usuarios = [
    7 => 2, 8 => 2, 10 => 2,
    5 => 3, 6 => 3, 11 => 3,
    3 => 5, 4 => 5,
    9 => 4
    // Puedes añadir más usuarios y sucursales aquí
    // Ejemplo: 1 => 1, 2 => 1, etc.
];

$respuesta = [
    'sucursales' => [],
    'usuarios' => [],
    'sucursal_origen_fija' => ID_SUCURSAL_ORIGEN_FIJA
];

try {
    // Obtener sucursales (sin cambios)
    $stmt_sucursales = $pdo->query("SELECT id, nombre FROM sucursales ORDER BY nombre ASC");
    $respuesta['sucursales'] = $stmt_sucursales->fetchAll(PDO::FETCH_ASSOC);
    
    // Obtener todos los usuarios
    $stmt_usuarios = $pdo->query("SELECT id, nombre FROM usuarios ORDER BY nombre ASC");
    $todos_los_usuarios = $stmt_usuarios->fetchAll(PDO::FETCH_ASSOC);

    // **NUEVO**: Asignar sucursal a cada usuario según el mapa
    $usuarios_filtrados = [];
    foreach ($todos_los_usuarios as $usuario) {
        $id_usuario = $usuario['id'];
        // Si el usuario está en nuestro mapa de asignación, le añadimos su sucursal_id
        if (isset($asignacion_usuarios[$id_usuario])) {
            $usuario['sucursal_id'] = $asignacion_usuarios[$id_usuario];
            $usuarios_filtrados[] = $usuario;
        } else {
            // Opcional: si quieres incluir usuarios sin sucursal asignada
            // $usuario['sucursal_id'] = null;
            // $usuarios_filtrados[] = $usuario;
        }
    }
    $respuesta['usuarios'] = $usuarios_filtrados;


} catch (PDOException $e) {
    // Manejo de errores
}

echo json_encode($respuesta);
?>