$(document).ready(function() {
    // Variable global para guardar la lista completa de usuarios
    let todosLosUsuarios = [];
    const idOrigenFijo = $('#sucursal_origen').val(); // Lo obtendremos después

    // **NUEVO**: Función para actualizar los menús de usuarios
    function actualizarSelectsDeUsuarios() {
        const idOrigen = $('#sucursal_origen').val();
        const idDestino = $('#sucursal_destino').val();
        const selectEnvia = $('#usuario_envia').empty();
        const selectRecibe = $('#usuario_recibe').empty();

        let usuariosEnviaEncontrados = 0;
        let usuariosRecibeEncontrados = 0;

        todosLosUsuarios.forEach(usuario => {
            // Poblar select de "Usuario que Envía"
            if (usuario.sucursal_id == idOrigen) {
                selectEnvia.append(new Option(usuario.nombre, usuario.id));
                usuariosEnviaEncontrados++;
            }
            // Poblar select de "Usuario que Recibirá"
            if (usuario.sucursal_id == idDestino) {
                selectRecibe.append(new Option(usuario.nombre, usuario.id));
                usuariosRecibeEncontrados++;
            }
        });

        if (usuariosEnviaEncontrados === 0) selectEnvia.append(new Option('No hay usuarios en Origen', ''));
        if (usuariosRecibeEncontrados === 0) selectRecibe.append(new Option('No hay usuarios en Destino', ''));
    }

    // Cargar datos iniciales
    function cargarDatosIniciales() {
        $.ajax({
            url: 'php/obtener_datos.php',
            type: 'GET',
            dataType: 'json',
            success: function(data) {
                todosLosUsuarios = data.usuarios; // Guardamos la lista de usuarios
                const sucursalOrigen = $('#sucursal_origen');
                const sucursalDestino = $('#sucursal_destino');
                const idOrigenFijo = data.sucursal_origen_fija;

                data.sucursales.forEach(s => {
                    if (s.id == idOrigenFijo) {
                        sucursalOrigen.append(new Option(s.nombre, s.id));
                    }
                    if (s.id != idOrigenFijo) {
                        sucursalDestino.append(new Option(s.nombre, s.id));
                    }
                });
                sucursalOrigen.prop('disabled', true);
                
                // Llamamos a la nueva función para poblar los usuarios por primera vez
                actualizarSelectsDeUsuarios(); 
            }
        });
    }

    // **NUEVO**: Evento que se dispara al cambiar la sucursal de destino
    $('#sucursal_destino').on('change', function() {
        actualizarSelectsDeUsuarios();
    });

    // --- El resto del código no necesita cambios ---

    // Búsqueda de productos
    $('#caja_busqueda').on('keyup', function() {
        let termino = $(this).val();
        let tablaResultados = $('#tabla_resultados_busqueda');
        if (termino.length < 2) { tablaResultados.empty(); return; }
        $.ajax({
            url: 'php/buscar_producto.php',
            type: 'POST',
            data: { termino: termino, pagina: 1 },
            dataType: 'json',
            success: function(response) {
                tablaResultados.empty();
                const productosHtml = $(response.tabla).map(function() {
                    const productoId = $(this).find('.btn-guardar').data('id');
                    const nombre = $(this).find('td:first-child').html();
                    if(productoId && nombre) {
                        return `<tr class="cursor-pointer" data-id="${productoId}" data-nombre="${$('<div>').html(nombre).text().trim()}"><td>${nombre}</td></tr>`;
                    }
                }).get().join('');
                tablaResultados.html(productosHtml);
            }
        });
    });

    // Añadir producto a la lista de traslado
    $('body').on('click', '#tabla_resultados_busqueda tr', function() {
        const productoId = $(this).data('id');
        const nombreProducto = $(this).data('nombre').replace('<br>', ' ');
        if ($(`#fila-traslado-${productoId}`).length > 0) {
            mostrarNotificacion('Este producto ya está en la lista.', 'warning'); return;
        }
        $('#fila_vacia').remove();
        const nuevaFila = `<tr id="fila-traslado-${productoId}" data-id="${productoId}"><td>${nombreProducto}</td><td><select class="form-select form-select-sm" name="presentacion"><option value="CAJA">Caja</option><option value="BLISTER">Blíster</option><option value="UNIDAD">Unidad</option></select></td><td><input type="number" class="form-control form-control-sm" name="cantidad" min="1" value="1"></td><td><div class="form-check form-switch"><input class="form-check-input" type="checkbox" name="sefactura" checked></div></td><td><button class="btn btn-danger btn-sm btn-quitar">X</button></td></tr>`;
        $('#tabla_productos_traslado').append(nuevaFila);
        $('#caja_busqueda').val('').focus();
        $('#tabla_resultados_busqueda').empty();
    });

    // Quitar producto de la lista
    $('body').on('click', '.btn-quitar', function() {
        $(this).closest('tr').remove();
        if ($('#tabla_productos_traslado tr').length === 0) {
             $('#tabla_productos_traslado').html('<tr id="fila_vacia"><td colspan="5" class="text-center text-muted">Aún no has añadido productos.</td></tr>');
        }
    });

    // Guardar el traslado completo
    $('#btn_guardar_traslado').on('click', function() {
        const trasladoData = {
            origen_id: $('#sucursal_origen').val(),
            destino_id: $('#sucursal_destino').val(),
            envia_id: $('#usuario_envia').val(),
            recibe_id: $('#usuario_recibe').val(),
            productos: []
        };
        $('#tabla_productos_traslado tr').each(function() {
            const fila = $(this);
            if(fila.data('id')) {
                const sefactura = fila.find('input[name="sefactura"]').is(':checked') ? 1 : 0;
                trasladoData.productos.push({ id: fila.data('id'), cantidad: fila.find('input[name="cantidad"]').val(), presentacion: fila.find('select[name="presentacion"]').val(), sefactura: sefactura });
            }
        });

        if (trasladoData.envia_id === trasladoData.recibe_id) {
            mostrarNotificacion('El usuario que envía no puede ser el mismo que recibe.', 'danger'); return;
        }
        if (!trasladoData.envia_id || !trasladoData.recibe_id) {
            mostrarNotificacion('Debe seleccionar un usuario en Origen y Destino.', 'danger'); return;
        }
        if (trasladoData.productos.length === 0) {
            mostrarNotificacion('Debes añadir al menos un producto al traslado.', 'danger'); return;
        }

        $.ajax({
            url: 'php/guardar_traslado.php',
            type: 'POST',
            contentType: 'application/json',
            data: JSON.stringify(trasladoData),
            dataType: 'json',
            success: function(response) {
                mostrarNotificacion(response.message, response.status);
                if (response.status === 'success') {
                    setTimeout(() => window.location.reload(), 2000);
                }
            },
            error: function() {
                mostrarNotificacion('Error de conexión al guardar.', 'danger');
            }
        });
    });
    
    // Función de notificación
    function mostrarNotificacion(mensaje, tipo = 'success') {
        const alerta = $('#alerta-notificacion');
        alerta.removeClass('alert-success alert-danger alert-warning d-none').addClass(`alert-${tipo === 'success' ? 'success' : 'danger'}`);
        alerta.text(mensaje).removeClass('d-none');
        setTimeout(() => alerta.addClass('d-none'), 4000);
    }
    
    // Carga inicial
    cargarDatosIniciales();
});