<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Traslado entre Sucursales - Sufarma</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="icon" href="data:image/svg+xml,<svg xmlns=%22http://www.w3.org/2000/svg%22 viewBox=%220 0 100 100%22><text y=%22.9em%22 font-size=%2290%22>🚚</text></svg>">
</head>
<body>

<div class="container my-4">
    <div class="card shadow-sm">
        <div class="card-header bg-info text-white">
            <h3 class="mb-0">Crear Nuevo Traslado</h3>
        </div>
        <div class="card-body">
            <fieldset class="border p-3 mb-4">
                <legend class="float-none w-auto px-2 h6">Datos del Traslado</legend>
                <div class="row g-3">
                    <div class="col-md-6">
                        <label for="sucursal_origen" class="form-label">Desde Sucursal (Origen)</label>
                        <select id="sucursal_origen" class="form-select"></select>
                    </div>
                    <div class="col-md-6">
                        <label for="sucursal_destino" class="form-label">Hacia Sucursal (Destino)</label>
                        <select id="sucursal_destino" class="form-select"></select>
                    </div>
                    <div class="col-md-6">
                        <label for="usuario_envia" class="form-label">Usuario que Envía</label>
                        <select id="usuario_envia" class="form-select"></select>
                    </div>
                    <div class="col-md-6">
                        <label for="usuario_recibe" class="form-label">Usuario que Recibirá</label>
                        <select id="usuario_recibe" class="form-select"></select>
                    </div>
                </div>
            </fieldset>

            <fieldset class="border p-3 mb-4">
                <legend class="float-none w-auto px-2 h6">Añadir Productos</legend>
                <div class="input-group mb-3">
                    <span class="input-group-text">🔍</span>
                    <input type="text" id="caja_busqueda" class="form-control" placeholder="Buscar producto para añadir al traslado...">
                </div>
                <div class="table-responsive" style="max-height: 250px;">
                    <table class="table table-sm table-hover">
                        <tbody id="tabla_resultados_busqueda"></tbody>
                    </table>
                </div>
            </fieldset>
            
            <h4 class="mt-4">Lista de Productos a Trasladar</h4>
            <div class="table-responsive">
                <table class="table table-striped">
                    <thead class="table-light">
                        <tr>
                            <th>Producto</th>
                            <th>Presentación</th>
                            <th>Cantidad</th>
                            <th>Facturable</th> <th style="width: 5%;">Quitar</th>
                        </tr>
                    </thead>
                    <tbody id="tabla_productos_traslado">
                        <tr id="fila_vacia"><td colspan="5" class="text-center text-muted">Aún no has añadido productos.</td></tr>
                    </tbody>
                </table>
            </div>
            
            <div class="d-grid mt-4">
                <button id="btn_guardar_traslado" class="btn btn-primary btn-lg">Confirmar y Guardar Traslado</button>
            </div>
        </div>
    </div>
    <div id="alerta-notificacion" class="alert d-none position-fixed bottom-0 end-0 m-3 shadow-lg" role="alert"></div>
</div>

<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="js/main.js"></script>
</body>
</html>