<?php
/**
 * Helper para gestión de sucursal activa
 */

define('BRANCH_CONFIG_FILE', __DIR__ . '/branch_config.json');

/**
 * Obtiene el ID de la sucursal activa
 * @return int ID de la sucursal
 */
function getCurrentBranchId() {
    if (!file_exists(BRANCH_CONFIG_FILE)) {
        // Default a 1 si no existe el archivo
        return 1;
    }
    
    $json = file_get_contents(BRANCH_CONFIG_FILE);
    $data = json_decode($json, true);
    
    return isset($data['sucursal_id']) ? (int)$data['sucursal_id'] : 1;
}

/**
 * Establece la sucursal activa
 * @param int $branchId ID de la sucursal
 * @return bool true si se guardó correctamente
 */
function setCurrentBranchId($branchId) {
    $data = ['sucursal_id' => (int)$branchId];
    return file_put_contents(BRANCH_CONFIG_FILE, json_encode($data, JSON_PRETTY_PRINT)) !== false;
}
