<?php
/**
 * API: Obtener Stock de Producto
 * Retorna el stock disponible de un producto en una sucursal específica
 */

header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json; charset=utf-8');

require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../config/branch.php';

try {
    $pdo = getDBConnection();
    
    $producto_id = isset($_GET['producto_id']) ? intval($_GET['producto_id']) : 0;
    $sucursal_id = getCurrentBranchId();
    
    if ($producto_id <= 0 || $sucursal_id <= 0) {
        sendJSON(['success' => false, 'error' => 'Parámetros inválidos'], 400);
    }
    
    $sql = "SELECT 
                i.presentacion,
                SUM(i.stock_unidad_base) as stock_unidades,
                l.fechavencimiento,
                l.codigo_lote
            FROM inventario i
            INNER JOIN lote l ON l.id = i.lote_id
            WHERE l.producto_id = :producto_id 
            AND i.sucursal_id = :sucursal_id
            AND i.stock_unidad_base > 0
            GROUP BY i.presentacion, l.id
            ORDER BY l.fechavencimiento ASC";
    
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        ':producto_id' => $producto_id,
        ':sucursal_id' => $sucursal_id
    ]);
    
    $stock = $stmt->fetchAll();
    
    sendJSON([
        'success' => true,
        'data' => $stock
    ]);
    
} catch (PDOException $e) {
    error_log("Error al obtener stock: " . $e->getMessage());
    sendJSON(['success' => false, 'error' => 'Error al obtener stock'], 500);
}
