<?php
/**
 * API: Obtener Filtros (Laboratorios y Categorías)
 * Retorna listas para poblar los selectores de filtro
 */

header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json; charset=utf-8');

require_once __DIR__ . '/../config/database.php';

try {
    $pdo = getDBConnection();
    
    // Obtener Laboratorios (distintos)
    $sqlLabs = "SELECT DISTINCT laboratorio FROM productos WHERE laboratorio IS NOT NULL AND laboratorio != '' ORDER BY laboratorio ASC";
    $stmtLabs = $pdo->query($sqlLabs);
    $laboratorios = $stmtLabs->fetchAll(PDO::FETCH_COLUMN);
    
    // Obtener Categorías
    $sqlCats = "SELECT id, nombre FROM categorias ORDER BY nombre ASC";
    $stmtCats = $pdo->query($sqlCats);
    $categorias = $stmtCats->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode([
        'success' => true,
        'data' => [
            'laboratorios' => $laboratorios,
            'categorias' => $categorias
        ]
    ]);
    
} catch (PDOException $e) {
    error_log("Error al obtener filtros: " . $e->getMessage());
    echo json_encode(['success' => false, 'error' => 'Error al obtener filtros'], 500);
}
?>
