<?php
include 'conexion.php';
include 'sucursal_config.php';

// Get current branch name
$query_sucursal = "SELECT nombre FROM sucursales WHERE id = ?";
$stmt = mysqli_prepare($conexion, $query_sucursal);
mysqli_stmt_bind_param($stmt, "i", $sucursal_id);
mysqli_stmt_execute($stmt);
$resultado = mysqli_stmt_get_result($stmt);
$sucursal = mysqli_fetch_assoc($resultado);
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gestión de Inventario - <?php echo $sucursal['nombre']; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
</head>
<body>
    <div class="container mt-4">
        <h2 class="mb-4">Gestión de Inventario - <?php echo $sucursal['nombre']; ?></h2>
        <a href="../index_simplificado.php" class="btn btn-secondary">Regresar a VENTAS</a>
        <div class="card">
            <div class="card-body">
                <form id="inventarioForm">
                    <input type="hidden" id="sucursal" name="sucursal" value="<?php echo $sucursal_id; ?>">
                    <div class="row mb-3">
                        <div class="col-md-12">
                            <label for="producto" class="form-label">Producto</label>
                            <select class="form-select" id="producto" name="producto" required>
                                <option value="">Buscar producto...</option>
                            </select>
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-4">
                            <label for="cantidad_unidad" class="form-label">Cantidad Unidades</label>
                            <input type="number" class="form-control" id="cantidad_unidad" name="cantidad_unidad" min="0" value="0">
                        </div>
                        <div class="col-md-4">
                            <label for="cantidad_blister" class="form-label">Cantidad Blister</label>
                            <input type="number" class="form-control" id="cantidad_blister" name="cantidad_blister" min="0" value="0">
                        </div>
                        <div class="col-md-4">
                            <label for="cantidad_caja" class="form-label">Cantidad Cajas</label>
                            <input type="number" class="form-control" id="cantidad_caja" name="cantidad_caja" min="0" value="0">
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-4">
                            <label for="fecha_vencimiento" class="form-label">Fecha de Vencimiento</label>
                            <input type="date" class="form-control" id="fecha_vencimiento" name="fecha_vencimiento" required>
                        </div>
                    </div>

                    <button type="submit" class="btn btn-primary">Registrar Inventario</button>
                </form>
            </div>
        </div>

        <div class="mt-4">
            <h3>Inventario Actual</h3>
            <div id="inventarioActual"></div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
        $(document).ready(function() {
            $('#producto').select2({
                placeholder: 'Buscar por código, nombre, laboratorio...',
                minimumInputLength: 2,
                ajax: {
                    url: 'buscar_productos_sucursal.php',
                    dataType: 'json',
                    delay: 250,
                    data: function(params) {
                        return {
                            search: params.term,
                            sucursal_id: $('#sucursal').val()
                        };
                    },
                    processResults: function(data) {
                        return {
                            results: data
                        };
                    },
                    cache: true
                }
            });

            $('#inventarioForm').on('submit', function(e) {
                e.preventDefault();
                $.ajax({
                    url: 'guardar_inventario.php',
                    method: 'POST',
                    data: $(this).serialize(),
                    success: function(response) {
                        if(response === 'success') {
                            alert('Inventario actualizado correctamente');
                            cargarInventario();
                            $('#inventarioForm')[0].reset();
                            $('#producto').val('').trigger('change');
                        } else {
                            alert('Error al actualizar el inventario');
                        }
                    },
                    error: function() {
                        alert('Error al actualizar el inventario');
                    }
                });
            });

            function cargarInventario() {
                const sucursal_id = $('#sucursal').val();
                if(sucursal_id) {
                    $.ajax({
                        url: 'obtener_inventario.php',
                        method: 'GET',
                        data: { sucursal_id: sucursal_id },
                        success: function(response) {
                            $('#inventarioActual').html(response);
                        }
                    });
                }
            }

            cargarInventario();
        });
    </script>
</body>
</html>