<?php
include 'conexion.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $sucursal_id = $_POST['sucursal'];
    $producto_id = $_POST['producto'];
    $cantidad_unidad = $_POST['cantidad_unidad'];
    $cantidad_blister = $_POST['cantidad_blister'];
    $cantidad_caja = $_POST['cantidad_caja'];
    $fecha_vencimiento = $_POST['fecha_vencimiento'];

    // Check if inventory record exists
    $check_query = "SELECT id FROM inventario_sucursal 
                   WHERE producto_id = ? AND sucursal_id = ?";
    $stmt = mysqli_prepare($conexion, $check_query);
    mysqli_stmt_bind_param($stmt, "ii", $producto_id, $sucursal_id);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);

    if (mysqli_num_rows($result) > 0) {
        // Update existing record
        $query = "UPDATE inventario_sucursal 
                 SET existencia_unidad = ?, 
                     existencia_blister = ?, 
                     existencia_caja = ?,
                     fecha_vencimiento = ?
                 WHERE producto_id = ? AND sucursal_id = ?";
        $stmt = mysqli_prepare($conexion, $query);
        mysqli_stmt_bind_param($stmt, "iiisii", 
            $cantidad_unidad, 
            $cantidad_blister, 
            $cantidad_caja,
            $fecha_vencimiento,
            $producto_id, 
            $sucursal_id
        );
    } else {
        // Insert new record
        $query = "INSERT INTO inventario_sucursal 
                 (producto_id, sucursal_id, existencia_unidad, existencia_blister, existencia_caja, fecha_vencimiento) 
                 VALUES (?, ?, ?, ?, ?, ?)";
        $stmt = mysqli_prepare($conexion, $query);
        mysqli_stmt_bind_param($stmt, "iiiiss", 
            $producto_id, 
            $sucursal_id, 
            $cantidad_unidad, 
            $cantidad_blister, 
            $cantidad_caja,
            $fecha_vencimiento
        );
    }

    if (mysqli_stmt_execute($stmt)) {
        echo "success";
    } else {
        echo "error";
    }
}