<?php
// --- CONFIGURACIÓN DE ZONA HORARIA ---
date_default_timezone_set('America/Guatemala');

// --- CONFIGURACIÓN DE LA BASE DE DATOS PARA TU HOSTING ---
define('DB_HOST', 'localhost');
define('DB_USER', 'farmacia_onlydi2025');
define('DB_PASS', '1corintios13');
define('DB_NAME', 'farmacia_sufarma2025');

// --- CONFIGURACIÓN DE LA SUCURSAL ---
// Este es el ID de la sucursal actual. En un sistema real, esto
// provendría de la sesión del usuario que ha iniciado sesión.
define('ID_SUCURSAL_ACTUAL', 3); // Asegúrate que una sucursal con id=1 exista.

// Crear la conexión a la base de datos usando PDO
try {
    // Se usa 'utf8mb4' para una mejor compatibilidad con caracteres especiales
    $pdo = new PDO("mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4", DB_USER, DB_PASS);
    
    // Configurar PDO para que lance excepciones en caso de error
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

} catch (PDOException $e) {
    // Detener la ejecución si la conexión falla y mostrar un mensaje de error
    die("ERROR: No se pudo conectar a la base de datos. " . $e->getMessage());
}

/**
 * Función para obtener todos los usuarios del sistema.
 * @param PDO $pdo Objeto de la conexión a la base de datos.
 * @return array Lista de usuarios.
 */
function obtenerUsuarios($pdo) {
    try {
        $stmt = $pdo->query("SELECT id, nombre FROM usuarios ORDER BY nombre ASC");
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    } catch (PDOException $e) {
        // En caso de error, devolver un array vacío para no detener la ejecución.
        return [];
    }
}
?>