$(document).ready(function() {
    
    // Función central para cargar productos (búsqueda y paginación)
    function cargarProductos(pagina = 1, termino = '') {
        const tablaResultados = $('#tabla_resultados');
        const contenedorPaginacion = $('#contenedor-paginacion');

        $.ajax({
            type: 'POST',
            url: 'php/buscar_producto.php',
            data: { pagina: pagina, termino: termino },
            dataType: 'json',
            beforeSend: function() {
                tablaResultados.html("<tr><td colspan='7' class='text-center'><div class='spinner-border spinner-border-sm'></div> Cargando...</td></tr>");
                contenedorPaginacion.empty();
            },
            success: function(response) {
                tablaResultados.html(response.tabla || "<tr><td colspan='7' class='text-center'>No hay resultados.</td></tr>");
                contenedorPaginacion.html(response.paginacion);
            },
            error: function() {
                tablaResultados.html("<tr><td colspan='7' class='text-center text-danger'>Error de conexión al servidor.</td></tr>");
            }
        });
    }

    // Carga inicial de productos
    cargarProductos();

    // Debounce para la búsqueda (espera a que el usuario termine de escribir)
    let typingTimer;
    $('#caja_busqueda').on('keyup', function() {
        clearTimeout(typingTimer);
        const terminoDeBusqueda = $(this).val();
        typingTimer = setTimeout(() => cargarProductos(1, terminoDeBusqueda), 500);
    });

    // Click en un enlace de paginación
    $('body').on('click', '.page-link', function(e) {
        e.preventDefault();
        const pagina = $(this).data('pagina');
        if (pagina) {
            cargarProductos(pagina, $('#caja_busqueda').val());
        }
    });
    
    // Click en el botón "Ingresar"
    $('body').on('click', '.btn-guardar', function() {
        let boton = $(this);
        let fila = boton.closest('tr');
        
        // Extraemos todos los datos de la fila
        let producto_id = boton.data('id');
        let lote_id = fila.find('input[name="lote_id"]').val(); // Del input oculto
        let cantidad = fila.find('input[name="cantidad"]').val();
        let presentacion = fila.find('select[name="presentacion"]').val();
        // Verificamos si el switch está activado
        let sefactura = fila.find('input[name="sefactura"]').is(':checked') ? 1 : 0;
        let usuario_entrega = fila.find('select[name="usuario_entrega"]').val();
        let usuario_recibe = fila.find('select[name="usuario_recibe"]').val();

        if (!cantidad || cantidad <= 0) {
            mostrarNotificacion('Error: La cantidad debe ser un número mayor a cero.', 'danger');
            return;
        }

        $.ajax({
            type: 'POST',
            url: 'php/guardar_ingreso.php',
            data: {
                producto_id: producto_id,
                lote_id: lote_id,
                cantidad: cantidad,
                presentacion: presentacion,
                sefactura: sefactura, // Enviamos el nuevo dato
                usuario_entrega: usuario_entrega,
                usuario_recibe: usuario_recibe
            },
            dataType: 'json',
            beforeSend: () => boton.prop('disabled', true).html('<span class="spinner-border spinner-border-sm"></span>'),
            success: function(response) {
                if(response.status === 'success') {
                    fila.addClass('table-success');
                    fila.find('input, select, button').prop('disabled', true);
                    boton.removeClass('btn-success').addClass('btn-secondary').text('Hecho');
                    mostrarNotificacion(response.message, 'success');
                } else {
                    mostrarNotificacion('Error: ' + response.message, 'danger');
                    boton.prop('disabled', false).text('Ingresar');
                }
            },
            error: () => {
                mostrarNotificacion('Error de conexión al guardar.', 'danger');
                boton.prop('disabled', false).text('Ingresar');
            }
        });
    });

    // Función para mostrar notificaciones
    function mostrarNotificacion(mensaje, tipo = 'success') {
        const alerta = $('#alerta-notificacion');
        alerta.removeClass('alert-success alert-danger').addClass(`alert-${tipo}`);
        alerta.text(mensaje).removeClass('d-none');
        setTimeout(() => alerta.addClass('d-none'), 4000);
    }
});