<?php
// get_last_sales.php
date_default_timezone_set('America/Guatemala'); // Ajusta la zona horaria
include 'db_connection.php';
include 'sucursal_config.php';

// Fecha de hoy
$hoy = date('Y-m-d');

// --- PASO 1: Obtener ventas Normales y Especiales del DÍA ---
$ventas = [];

// Ventas normales del día
$sqlNormal = "SELECT id, fecha_y_hora, total, 'Normal' AS tipo
              FROM ventas
              WHERE sucursal_id = ? AND DATE(fecha_y_hora) = ?
              ORDER BY fecha_y_hora DESC";
$stmtN = $conn->prepare($sqlNormal);
$stmtN->bind_param("is", $sucursal_id, $hoy);
$stmtN->execute();
$resN = $stmtN->get_result();
while ($rowN = $resN->fetch_assoc()) {
    $ventas[] = $rowN;
}

// Ventas especiales del día
$sqlEspecial = "SELECT id, fecha_y_hora, precio AS total, 'Especial' AS tipo
                FROM ventas_especiales
                WHERE sucursal_id = ? AND DATE(fecha_y_hora) = ?
                ORDER BY fecha_y_hora DESC";
$stmtE = $conn->prepare($sqlEspecial);
$stmtE->bind_param("is", $sucursal_id, $hoy);
$stmtE->execute();
$resE = $stmtE->get_result();
while ($rowE = $resE->fetch_assoc()) {
    $ventas[] = $rowE;
}

// --- PASO 2: Ordenar el arreglo combinado por fecha desc ---
usort($ventas, function($a, $b) {
    return strtotime($b['fecha_y_hora']) - strtotime($a['fecha_y_hora']);
});

// --- PASO 3: Preparar la respuesta JSON ---
foreach ($ventas as &$venta) {
    $venta['fecha_y_hora_display'] = date('d/m/Y H:i', strtotime($venta['fecha_y_hora']));
}

// Enviar respuesta JSON con TODAS las ventas del día
echo json_encode([
    'success' => true,
    'ventas' => $ventas
]);

$conn->close();
?>