<?php
date_default_timezone_set('America/Guatemala');
include 'db_connection.php';
include 'sucursal_config.php';

header('Content-Type: application/json');

$venta_id = isset($_GET['venta_id']) ? intval($_GET['venta_id']) : 0;
$tipo = isset($_GET['tipo']) ? $_GET['tipo'] : '';

if ($venta_id <= 0 || !in_array($tipo, ['normal', 'especial'])) {
    echo json_encode([
        'success' => false,
        'message' => 'Parámetros inválidos'
    ]);
    exit;
}

if ($tipo === 'normal') {
    // Obtener detalle de venta normal
    $sql = "SELECT 
                dv.venta_id,
                p.CodigoInterno,
                p.NombreComercial,
                p.Laboratorio,
                dv.cantidad,
                dv.subtotal,
                p.exento_iva, -- <-- LÍNEA AÑADIDA
                (SELECT SUM(subtotal) FROM detalle_ventas WHERE venta_id = dv.venta_id) as total
            FROM detalle_ventas dv
            JOIN productos p ON dv.producto_id = p.id
            WHERE dv.venta_id = ?";
    
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $venta_id);
} else {
    // Obtener detalle de venta especial
    $sql = "SELECT 
                precio as total,
                descripcion as nombre,
                '1' as cantidad,
                precio as subtotales
            FROM ventas_especiales
            WHERE id = ? AND sucursal_id = ?";
    
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ii", $venta_id, $sucursal_id);
}

$stmt->execute();
$result = $stmt->get_result();

// --- TU CÓDIGO ORIGINAL PARA PROCESAR EL RESULTADO ---
if ($tipo === 'normal' && $result->num_rows > 0) { // Se añade validación de filas
    $productos = array();
    $total = 0;
    
    // Obtener todos los productos y calcular el total
    while ($row = $result->fetch_assoc()) {
        $productos[] = [
            'codigo_interno' => $row['CodigoInterno'],
            'nombre' => $row['NombreComercial'],
            'laboratorio' => $row['Laboratorio'],
            'cantidad' => $row['cantidad'],
            'subtotal' => $row['subtotal'],
            'exento_iva' => $row['exento_iva'] // <-- LÍNEA AÑADIDA
        ];
        $total += $row['subtotal'];
    }
    
    echo json_encode([
        'success' => true,
        'venta' => [
            'productos' => $productos,
            'total' => number_format($total, 2) // Se formatea el total
        ]
    ]);
} else if ($tipo === 'especial' && $result->num_rows > 0) { // Lógica para venta especial
    $row = $result->fetch_assoc();
    echo json_encode([
        'success' => true,
        'venta' => [
            'productos' => [[
                'codigo_interno' => 'N/A',
                'nombre' => $row['nombre'],
                'laboratorio' => 'N/A',
                'cantidad' => 1,
                'subtotal' => $row['subtotales'],
                'exento_iva' => 0 // Especiales no son exentas
            ]],
            'total' => number_format($row['total'], 2)
        ]
    ]);
}
else {
    echo json_encode([
        'success' => false,
        'message' => 'No se encontraron detalles de la venta'
    ]);
}
?>