<?php
// get_detalle_venta_especial.php
date_default_timezone_set('America/Guatemala'); // Ajusta la zona horaria seg��n tu ubicaci��n
include 'db_connection.php';
include 'sucursal_config.php';

// Recibir el id de la venta
$venta_id = isset($_GET['venta_id']) ? intval($_GET['venta_id']) : 0;

// Detectar si se solicita en formato JSON o HTML
$format = isset($_GET['format']) ? $_GET['format'] : 'html';

if ($venta_id <= 0) {
    if($format === 'json'){
        echo json_encode([
            'success' => false,
            'message' => 'Venta inválida.'
        ]);
    } else {
        echo "<p>Venta inválida.</p>";
    }
    exit;
}

// Query para obtener el detalle de la venta especial
$sqlDet = "
    SELECT descripcion, precio
    FROM ventas_especiales
    WHERE id = ?
      AND sucursal_id = ?
    LIMIT 1
";
$stmt = $conn->prepare($sqlDet);
$stmt->bind_param("ii", $venta_id, $sucursal_id);
$stmt->execute();
$res = $stmt->get_result();

if ($res && $row = $res->fetch_assoc()) {
    if($format === 'json'){
        // Responder con detalle en formato JSON
        echo json_encode([
            'success' => true,
            'detalle' => [
                'descripcion' => htmlspecialchars($row['descripcion'], ENT_QUOTES, 'UTF-8'),
                'precio' => $row['precio']
            ]
        ]);
    } else {
        // Responder con HTML
        echo "<table class='table table-sm'>";
        echo "<thead><tr><th>Descripción</th><th>Precio</th></tr></thead><tbody>";
        echo "<tr><td>" . htmlspecialchars($row['descripcion'], ENT_QUOTES, 'UTF-8') . "</td><td>Q " . number_format($row['precio'], 2) . "</td></tr>";
        echo "</tbody></table>";
    }
} else {
    if($format === 'json'){
        echo json_encode([
            'success' => false,
            'message' => 'No se encontró la venta especial.'
        ]);
    } else {
        echo "<p>No hay detalle para esta venta especial.</p>";
    }
}
?>
