<?php
// get_detalle_venta.php
date_default_timezone_set('America/Guatemala');
include 'db_connection.php';
include 'sucursal_config.php';

// Recibir el id de la venta
$venta_id = isset($_GET['venta_id']) ? intval($_GET['venta_id']) : 0;
$format = isset($_GET['format']) ? $_GET['format'] : 'html';

if ($venta_id <= 0) {
    if($format === 'json'){
        echo json_encode(['success' => false, 'message' => 'Venta inválida.']);
    } else {
        echo "<p>Venta inválida.</p>";
    }
    exit;
}

// Query para obtener el detalle (incluye exento_iva por consistencia)
$sqlDet = "
    SELECT dv.cantidad, dv.precio, dv.subtotal, dv.facturado, dv.estado_factura,
           p.NombreComercial, p.laboratorio, p.exento_iva
    FROM detalle_ventas dv
    JOIN productos p ON dv.producto_id = p.id
    WHERE dv.venta_id = ?
";
$stmt = $conn->prepare($sqlDet);
$stmt->bind_param("i", $venta_id);
$stmt->execute();
$res = $stmt->get_result();

if (!$res || $res->num_rows === 0) {
    // Manejo de error si no hay detalle
    if ($format === 'json') {
        echo json_encode(['success' => false, 'message' => 'No se encontró detalle para esta venta.']);
    } else {
        echo "<p>No se encontró detalle para esta venta.</p>";
    }
    exit;
}

if ($format === 'json') {
    // --- JSON para edición desde index_simplificado.php ---
    // Se devuelven las claves que el carrito espera: NombreComercial, laboratorio, cantidad, precio y facturado
    $detalle = [];
    while ($row = $res->fetch_assoc()) {
         $detalle[] = [
            'NombreComercial' => htmlspecialchars($row['NombreComercial'], ENT_QUOTES, 'UTF-8'),
            'laboratorio'     => htmlspecialchars($row['laboratorio'], ENT_QUOTES, 'UTF-8'),
            'cantidad'        => (int)$row['cantidad'],
            'precio'          => (float)$row['precio'],
            'facturado'       => (int)$row['facturado']
        ];
    }
    echo json_encode([
        'success' => true,
        'detalle' => $detalle
    ]);

} else {
    // Generar tabla HTML (para la vista de "ver_ventas.php", sin cambios)
    $output = '<table class="table table-sm table-bordered">';
    $output .= '<thead class="table-light">
        <tr>
          <th>Producto</th><th>Laboratorio</th><th>Cantidad</th><th>Precio</th><th>Subtotal</th>
          <th>Exento IVA</th><th>Facturado</th><th>Estado Factura</th>
        </tr>
    </thead><tbody>';
    while ($row = $res->fetch_assoc()) {
        $es_exento     = $row['exento_iva'] ? 'Sí' : 'No';
        $facturado     = $row['facturado'] ? 'Sí' : 'No';
        $estadoFactura = $row['facturado'] ? ($row['estado_factura'] ?: 'Pendiente') : '-';

        $output .= "<tr>
            <td>".htmlspecialchars($row['NombreComercial'])."</td><td>".htmlspecialchars($row['laboratorio'])."</td>
            <td>".(int)$row['cantidad']."</td><td>Q ".number_format($row['precio'], 2)."</td>
            <td>Q ".number_format($row['subtotal'], 2)."</td><td>{$es_exento}</td>
            <td>{$facturado}</td><td>{$estadoFactura}</td>
        </tr>";
    }
    $output .= '</tbody></table>';
    echo $output;
}

$stmt->close();
$conn->close();
?>