<?php
// finalizar_venta_especial.php
date_default_timezone_set('America/Guatemala'); // Ajusta la zona horaria seg��n tu ubicaci��n
include 'db_connection.php';
include 'sucursal_config.php';

// 1. Recibir datos por POST
$descripcion = $_POST['descripcion'] ?? '';
$precio      = $_POST['precio'] ?? 0;

// Validar que haya descripción y precio mayor a 0
if (empty($descripcion) || $precio <= 0) {
    echo json_encode([
        'success' => false,
        'message' => 'Descripción vacía o precio inválido'
    ]);
    exit;
}

// 2. Insertar en tabla ventas_especiales
$fecha = date('Y-m-d H:i:s');
$sql = "INSERT INTO ventas_especiales (fecha_y_hora, descripcion, precio, sucursal_id)
        VALUES (?, ?, ?, ?)";
$stmt = $conn->prepare($sql);
$stmt->bind_param("ssdi", $fecha, $descripcion, $precio, $sucursal_id);

if (!$stmt->execute()) {
    echo json_encode([
        'success' => false,
        'message' => 'Error al insertar la venta especial: ' . $stmt->error
    ]);
    exit;
}

$idVentaEspecial = $stmt->insert_id;

// 3. Responder
echo json_encode([
    'success' => true,
    'id_venta_especial' => $idVentaEspecial,
    'message' => 'Venta especial registrada exitosamente.'
]);
exit;
?>
