<?php
// Muestra todos los errores de PHP para ayudar a depurar
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Siempre devolveremos JSON
header('Content-Type: application/json');

// Incluimos los archivos necesarios
require_once '../sucursal.php'; 
require_once 'db_connection.php';

// Verificamos la conexión a la base de datos inmediatamente
if ($conexion->connect_error) {
    die(json_encode(['success' => false, 'message' => 'Error de conexión a la BD: ' . $conexion->connect_error]));
}

// Verificamos que todos los datos necesarios hayan sido enviados desde el formulario
if (!isset($_POST['producto_id'], $_POST['codigo_lote'], $_POST['fechavencimiento'], $_POST['presentacion'], $_POST['cantidad'], $_POST['sefactura'])) {
    die(json_encode(['success' => false, 'message' => 'Faltan datos en la solicitud.']));
}

// Iniciar transacción para asegurar la integridad de los datos
$conexion->begin_transaction();

try {
    // 1. Insertar en la tabla 'lote'
    $stmt_lote = $conexion->prepare("INSERT INTO lote (producto_id, sefactura, codigo_lote, codigobarra, fechavencimiento) VALUES (?, ?, ?, ?, ?)");
    
    $codigoBarra = !empty($_POST['codigobarra']) ? $_POST['codigobarra'] : null;
    
    $stmt_lote->bind_param("iisss", 
        $_POST['producto_id'], 
        $_POST['sefactura'], 
        $_POST['codigo_lote'], 
        $codigoBarra, 
        $_POST['fechavencimiento']
    );
    $stmt_lote->execute();
    $nuevo_lote_id = $conexion->insert_id;

    // 2. Insertar en la tabla 'inventario'
    $stmt_inventario = $conexion->prepare("INSERT INTO inventario (lote_id, sucursal_id, stock_unidad_base, presentacion) VALUES (?, ?, ?, ?)");
    
    // =======================================================
    // ========= AQUÍ ESTÁ LA CORRECCIÓN IMPORTANTE ==========
    // =======================================================
    $id_sucursal_actual = ID_SUCURSAL_ACTIVA; // Asignamos la constante a una variable
    
    $stmt_inventario->bind_param("iiis", 
        $nuevo_lote_id, 
        $id_sucursal_actual, // Y usamos la variable aquí
        $_POST['cantidad'], 
        $_POST['presentacion']
    );
    $stmt_inventario->execute();

    // Si todo fue bien, confirmar la transacción
    $conexion->commit();
    echo json_encode(['success' => true, 'message' => 'Inventario registrado correctamente.']);

} catch (mysqli_sql_exception $exception) {
    // Si algo falló, revertir la transacción
    $conexion->rollback();
    echo json_encode(['success' => false, 'message' => 'Error de SQL: ' . $exception->getMessage()]);
}

$conexion->close();
?>