<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ingreso de Inventario</title>
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <?php require_once 'sucursal.php'; ?>
    <div class="container mt-4">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
    <div>
        <h3>Ingresar Lotes a Inventario</h3>
        <p class="mb-0">Sucursal activa: <strong><?php echo NOMBRE_SUCURSAL_ACTIVA; ?></strong></p>
    </div>
    <div>
        <a href="ver_inventario.php" class="btn btn-info">Ver Inventario</a>
    </div>
</div>
            <div class="card-body">
                <div class="row mb-3">
                    <div class="col-md-6">
                        <label for="buscador_producto" class="form-label">Buscar Producto (Código o Nombre)</label>
                        <input type="text" id="buscador_producto" class="form-control" placeholder="Escribe para buscar...">
                        <div id="resultados_busqueda" class="list-group mt-1 position-absolute" style="z-index: 1000;"></div>
                    </div>
                </div>

                <h5 class="mt-4">Lotes a Ingresar</h5>
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th style="width: 20%;">Producto / Lab</th>
                                <th style="width: 15%;">Códigos</th>
                                <th>Lote</th>
                                <th>Vencimiento</th>
                                <th>Presentación</th>
                                <th>Cant.</th>
                                <th>Factura</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody id="tabla_lotes">
                            </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <script src="assets/js/jquery.min.js"></script>
    <script src="assets/js/bootstrap.bundle.min.js"></script>
    <script src="assets/js/main.js"></script>
</body>
</html>