$(document).ready(function() {

    // --- BUSCADOR DE PRODUCTOS ---
    $('#buscador_producto').on('keyup', function() {
        let termino = $(this).val();
        if (termino.length > 2) {
            $.ajax({
                url: 'php_logic/buscar_producto.php',
                type: 'POST',
                data: { termino: termino },
                dataType: 'json',
                success: function(productos) {
                    let lista = $('#resultados_busqueda');
                    lista.empty();
                    productos.forEach(p => {
                        lista.append(`<a href="#" class="list-group-item list-group-item-action" data-id="${p.id}">${p.NombreComercial} - ${p.laboratorio}</a>`);
                    });
                }
            });
        } else {
            $('#resultados_busqueda').empty();
        }
    });

    // --- SELECCIONAR UN PRODUCTO DE LA LISTA ---
    $(document).on('click', '#resultados_busqueda a', function(e) {
        e.preventDefault();
        let productoId = $(this).data('id');
        
        // Ocultar la lista de búsqueda y limpiar el input
        $('#resultados_busqueda').empty();
        $('#buscador_producto').val('');

        // Obtenemos los detalles completos del producto para agregar la fila
        $.ajax({
            url: 'php_logic/buscar_producto.php',
            type: 'POST',
            data: { id_exacto: productoId },
            dataType: 'json',
            success: function(producto) {
                if(producto && producto.length > 0) {
                    agregarFilaLote(producto[0]);
                }
            }
        });
    });

    // --- FUNCIÓN PARA AGREGAR FILA DE LOTE A LA TABLA ---
    function agregarFilaLote(p) {
        // Generar un código de lote automático (ej: 'L' + últimos 6 dígitos del timestamp)
        const codigoLote = 'L' + Date.now().toString().slice(-6);

        const fila = `
            <tr data-product-id="${p.id}">
                <td>
                    <strong>${p.NombreComercial}</strong><br>
                    <small>${p.laboratorio || 'N/A'}</small>
                </td>
                <td>
                    <small>Int: ${p.CodigoInterno || 'N/A'}</small><br>
                    <input type="text" class="form-control form-control-sm" name="codigobarra" value="${p.CodigoBarra || ''}" placeholder="Cód. Barras Lote">
                </td>
                <td>
                    <input type="text" class="form-control form-control-sm" name="codigo_lote" value="${codigoLote}" readonly>
                </td>
                <td>
                    <input type="date" class="form-control form-control-sm" name="fechavencimiento" required>
                </td>
                <td>
    <select class="form-select form-select-sm" name="presentacion">
        <option value="UNIDAD">Unidad</option>
        <option value="BLISTER">Blister</option>
        <option value="CAJA">Caja</option>
        <option value="BOTE">Bote</option>
        <option value="PAQUETE">Paquete</option> <option value="FARDO">Fardo</option>   </select>
</td>
                <td>
                    <input type="number" class="form-control form-control-sm" name="cantidad" min="1" value="1">
                </td>
                <td>
                    <div class="form-check d-flex justify-content-center">
                        <input class="form-check-input" type="checkbox" name="sefactura" checked>
                    </div>
                </td>
                <td>
                    <button class="btn btn-sm btn-success btn-guardar">Guardar</button>
                    <button class="btn btn-sm btn-primary btn-otro-lote" title="Agregar otro lote a este producto">+</button>
                    <button class="btn btn-sm btn-danger btn-eliminar">X</button>
                </td>
            </tr>
        `;
        $('#tabla_lotes').append(fila);
    }

    // --- ACCIÓN DE GUARDAR LOTE (VERSIÓN MEJORADA) ---
    $(document).on('click', '.btn-guardar', function() {
        const fila = $(this).closest('tr');
        const boton = $(this);

        if(fila.find('input[name="fechavencimiento"]').val() === '') {
            alert('Por favor, ingresa la fecha de vencimiento.');
            return;
        }

        const datosLote = {
            producto_id: fila.data('product-id'),
            codigo_lote: fila.find('input[name="codigo_lote"]').val(),
            codigobarra: fila.find('input[name="codigobarra"]').val(),
            fechavencimiento: fila.find('input[name="fechavencimiento"]').val(),
            presentacion: fila.find('select[name="presentacion"]').val(),
            cantidad: fila.find('input[name="cantidad"]').val(),
            sefactura: fila.find('input[name="sefactura"]').is(':checked') ? 1 : 0
        };

        boton.prop('disabled', true).text('Guardando...');

        $.ajax({
            url: 'php_logic/guardar_lote.php',
            type: 'POST',
            data: datosLote,
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    fila.addClass('table-success');
                    // Creamos el nuevo contenido para la celda de acciones
                    const nuevoContenidoAcciones = `
                        <div class="d-flex align-items-center justify-content-end">
                            <span class="text-success fw-bold me-2">Guardado ✔</span>
                            <button class="btn btn-sm btn-primary btn-otro-lote" title="Agregar otro lote para este producto">+</button>
                        </div>
                    `;
                    // Reemplazamos el contenido de la última celda
                    fila.find('td:last').html(nuevoContenidoAcciones);
                } else {
                    alert('Error: ' + response.message);
                    boton.prop('disabled', false).text('Guardar');
                }
            },
            error: function(xhr, status, error) {
                console.error("Error en la petición Ajax a guardar_lote.php:");
                console.error("Status:", status);
                console.error("Error:", error);
                console.error("Respuesta del servidor:", xhr.responseText);
                alert('Error al guardar. Revisa la consola del desarrollador (F12) para más detalles.');
                boton.prop('disabled', false).text('Guardar');
            }
        });
    });

    // --- ACCIÓN DE ELIMINAR FILA ---
    $(document).on('click', '.btn-eliminar', function() {
        $(this).closest('tr').remove();
    });

    // --- ACCIÓN PARA AGREGAR OTRO LOTE DEL MISMO PRODUCTO ---
    $(document).on('click', '.btn-otro-lote', function() {
        const filaOriginal = $(this).closest('tr');
        const productoId = filaOriginal.data('product-id');

        // Volvemos a pedir los datos del producto para tener una fila limpia
         $.ajax({
            url: 'php_logic/buscar_producto.php',
            type: 'POST',
            data: { id_exacto: productoId },
            dataType: 'json',
            success: function(producto) {
                if(producto && producto.length > 0) {
                   agregarFilaLote(producto[0]);
                }
            }
        });
    });

});