<?php
header('Content-Type: application/json');

require_once 'db_connection.php';

// Obtener los datos POST
$venta_id = isset($_POST['venta_id']) ? intval($_POST['venta_id']) : 0;
$tipo_venta = isset($_POST['tipo_venta']) ? $_POST['tipo_venta'] : '';
$estado = isset($_POST['estado']) ? $_POST['estado'] : '';

// Validar datos
if (!$venta_id || empty($tipo_venta) || empty($estado)) {
    echo json_encode(['success' => false, 'message' => 'Datos incompletos']);
    exit;
}

// Usar la conexión global de MySQLi
global $conn;

if (!$conn || $conn->connect_error) {
    echo json_encode(['success' => false, 'message' => 'Error de conexión a la base de datos']);
    exit;
}

// Determinar la tabla según el tipo de venta
$tabla_detalle = ($tipo_venta === 'normal') ? 'detalle_ventas' : 'detalle_venta_especial';

try {
    // Actualizar el estado de los productos
    $sql = "UPDATE $tabla_detalle SET estado_factura = ? WHERE venta_id = ?";
    $stmt = $conn->prepare($sql);
    
    if (!$stmt) {
        throw new Exception('Error al preparar la consulta');
    }
    
    $stmt->bind_param('si', $estado, $venta_id);
    
    if ($stmt->execute()) {
        echo json_encode(['success' => true]);
    } else {
        throw new Exception('Error al ejecutar la consulta');
    }
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Error en la base de datos: ' . $e->getMessage()]);
} finally {
    if (isset($stmt)) {
        $stmt->close();
    }
}