<?php
require_once 'config.php';

// Recibimos el HTML del select que construyó el JS
$select_usuarios_html = $_GET['select_html'] ?? "<select disabled><option>Error</option></select>";

// Consulta para buscar traslados EN TRÁNSITO hacia MI sucursal
$sql = "SELECT 
            t.id AS traslado_id,
            p.NombreComercial,
            dt.cantidad_unidad,
            dt.cantidad_blister,
            dt.cantidad_caja,
            dt.sefactura,
            s_origen.nombre AS sucursal_origen,
            u_envia.nombre AS usuario_envia
        FROM detalle_traslados AS dt
        JOIN traslados AS t ON dt.traslado_id = t.id
        JOIN productos AS p ON dt.producto_id = p.id
        JOIN sucursales AS s_origen ON t.sucursal_origen = s_origen.id
        JOIN usuarios AS u_envia ON t.usuario_id = u_envia.id
        WHERE t.sucursal_destino = ? AND t.estado = 'en_transito'
        ORDER BY t.fecha_traslado ASC"; // Mostrar los más antiguos primero

try {
    $stmt = $pdo->prepare($sql);
    $stmt->execute([ID_SUCURSAL_ACTUAL]);
    $traslados_pendientes = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if ($traslados_pendientes) {
        $html = '';
        foreach ($traslados_pendientes as $t) {
            
            // Determinar cantidad y presentación
            $cantidad = 0;
            $presentacion = 'N/A';
            if ($t['cantidad_caja'] > 0) {
                $cantidad = $t['cantidad_caja'];
                $presentacion = 'Caja';
            } elseif ($t['cantidad_blister'] > 0) {
                $cantidad = $t['cantidad_blister'];
                $presentacion = 'Blíster';
            } elseif ($t['cantidad_unidad'] > 0) {
                $cantidad = $t['cantidad_unidad'];
                $presentacion = 'Unidad';
            }
            
            // Texto para "Facturable"
            $facturable_texto = $t['sefactura'] == 1 
                ? "<span class='badge bg-success'>SI</span>" 
                : "<span class='badge bg-secondary'>NO</span>";

            $html .= "<tr id='traslado-{$t['traslado_id']}'>";
            $html .= "<td>{$t['NombreComercial']}</td>";
            $html .= "<td>{$cantidad} ({$presentacion})</td>";
            $html .= "<td>{$facturable_texto}</td>";
            $html .= "<td>{$t['sucursal_origen']}</td>";
            $html .= "<td>{$t['usuario_envia']}</td>";
            $html .= "<td>{$select_usuarios_html}</td>"; // Insertamos el dropdown
            $html .= "<td>
                        <button class='btn btn-success btn-sm btn-accion btn-aceptar' data-id='{$t['traslado_id']}'>Aceptar</button>
                        <button class='btn btn-danger btn-sm btn-accion btn-rechazar' data-id='{$t['traslado_id']}'>Rechazar</button>
                      </td>";
            $html .= "</tr>";
        }
        echo $html;
    } else {
        echo "<tr><td colspan='7' class='text-center'>No hay traslados pendientes.</td></tr>";
    }

} catch (PDOException $e) {
    echo "<tr><td colspan='7' class='text-center text-danger'>Error de base de datos: " . $e->getMessage() . "</td></tr>";
}
?>