<?php
header('Content-Type: application/json');
require_once 'config.php';

// Opcional: Esto oculta advertencias "Deprecated" sin arreglarlas, 
// pero es mejor arreglarlas como hacemos abajo.
// error_reporting(E_ALL & ~E_DEPRECATED);

$respuesta = ['status' => 'error', 'message' => 'Datos inválidos o faltantes.'];

// Comprobamos que todos los datos esperados lleguen
if (isset($_POST['producto_id'], $_POST['cantidad'], $_POST['presentacion'], $_POST['usuario_entrega'], $_POST['usuario_recibe'], $_POST['fecha_vencimiento'])) {
    
    // Recolectar y sanitizar datos
    $producto_id     = filter_var($_POST['producto_id'], FILTER_VALIDATE_INT);
    $lote_id         = filter_var($_POST['lote_id'], FILTER_VALIDATE_INT); // Puede ser 0
    $cantidad        = filter_var($_POST['cantidad'], FILTER_VALIDATE_INT);
    
    // =============================================
    // CAMBIO 1 (Línea 14 aprox)
    // =============================================
    $presentacion    = filter_var($_POST['presentacion'], FILTER_UNSAFE_RAW); // ANTES: FILTER_SANITIZE_STRING
    
    $sefactura       = isset($_POST['sefactura']) && $_POST['sefactura'] == '1' ? 1 : 0;
    $usuario_entrega = filter_var($_POST['usuario_entrega'], FILTER_VALIDATE_INT);
    $usuario_recibe  = filter_var($_POST['usuario_recibe'], FILTER_VALIDATE_INT);

    // =============================================
    // CAMBIO 2 (Línea 19 aprox)
    // =============================================
    $fecha_vencimiento_raw = filter_var($_POST['fecha_vencimiento'], FILTER_UNSAFE_RAW); // ANTES: FILTER_SANITIZE_STRING
    
    $sucursal_id     = ID_SUCURSAL_ACTUAL;

    // --- VALIDACIÓN DE FECHA MÁS ROBUSTA ---
    $timestamp = strtotime($fecha_vencimiento_raw);
    $es_fecha_valida = $timestamp !== false;
    $fecha_vencimiento_sql = date('Y-m-d', $timestamp);
    // --- FIN VALIDACIÓN ---


    // Validar datos básicos
    if ($producto_id && $cantidad > 0 && $usuario_entrega && $usuario_recibe && $es_fecha_valida) {
        try {
            $pdo->beginTransaction(); // Iniciar transacción

            // --- Lógica de Creación de Lote ---
            if ($lote_id === 0) {
                
                $codigo_lote_nuevo = 'L' . $producto_id . '-' . date('Ymd-His'); 
                $vencimiento_nuevo = $fecha_vencimiento_sql;

                $sql_lote = "INSERT INTO lote (producto_id, sefactura, codigo_lote, fechavencimiento) VALUES (?, ?, ?, ?)";
                $stmt_lote = $pdo->prepare($sql_lote);
                $stmt_lote->execute([$producto_id, $sefactura, $codigo_lote_nuevo, $vencimiento_nuevo]);
                
                $lote_id = $pdo->lastInsertId();
            } else {
                // Si el lote ya existe, actualizamos su estado 'sefactura' y vencimiento
                $sql_update_lote = "UPDATE lote SET sefactura = ?, fechavencimiento = ? WHERE id = ?";
                $stmt_update = $pdo->prepare($sql_update_lote);
                $stmt_update->execute([$sefactura, $fecha_vencimiento_sql, $lote_id]);
            }

            // --- Registrar el Ingreso en Sucursal ---
            $observaciones = ''; // Campo observaciones vacío por defecto

            $sql_ingreso = "INSERT INTO ingresos_sucursal 
                                (producto_id, lote_id, sucursal_id, cantidad_ingresada, presentacion_ingresada, fecha_ingreso, usuario_entrega_id, usuario_recibe_id, observaciones, fecha_vencimiento_ingreso) 
                            VALUES (?, ?, ?, ?, ?, NOW(), ?, ?, ?, ?)";

            $stmt_ingreso = $pdo->prepare($sql_ingreso);
            $stmt_ingreso->execute([$producto_id, $lote_id, $sucursal_id, $cantidad, $presentacion, $usuario_entrega, $usuario_recibe, $observaciones, $fecha_vencimiento_sql]);

            if ($stmt_ingreso->rowCount() > 0) {
                $pdo->commit(); 
                $respuesta['status'] = 'success';
                $respuesta['message'] = '¡Ingreso registrado correctamente!';
            } else {
                $pdo->rollBack(); 
                $respuesta['message'] = 'No se pudo registrar el ingreso.';
            }

        } catch (PDOException $e) {
            $pdo->rollBack(); 
            $respuesta['message'] = 'Error de base de datos: ' . $e->getMessage();
        }
    } else if (!$es_fecha_valida) {
        $respuesta['message'] = 'La fecha de vencimiento (' . htmlspecialchars($fecha_vencimiento_raw) . ') no es válida.';
    } else {
        $respuesta['message'] = 'Faltan datos obligatorios (producto, cantidad, usuarios o fecha).';
    }
}

echo json_encode($respuesta);
?>