$(document).ready(function() {
    
    function cargarHistorialTraslados(tipo = 'enviados') { // Por defecto muestra 'enviados'
        const tablaHistorial = $('#tabla_historial_traslados');
        const descripcion = $('#descripcion_historial');

        let descripcionTexto = tipo === 'enviados' 
            ? 'Mostrando traslados enviados desde esta sucursal.' 
            : 'Mostrando traslados recibidos en esta sucursal.';
        
        descripcion.text(descripcionTexto);

        $.ajax({
            type: 'GET',
            url: 'php/listar_traslados.php',
            data: { tipo: tipo }, // Enviamos el tipo de filtro
            beforeSend: function() {
                tablaHistorial.html("<tr><td colspan='10' class='text-center'><div class='spinner-border spinner-border-sm'></div> Cargando...</td></tr>");
            },
            success: function(response) {
                tablaHistorial.html(response || "<tr><td colspan='10' class='text-center'>No hay traslados.</td></tr>");
            },
            error: function() {
                tablaHistorial.html("<tr><td colspan='10' class='text-center text-danger'>Error al cargar el historial.</td></tr>");
            }
        });
    }

    // Carga inicial del historial (enviados)
    cargarHistorialTraslados('enviados');

    // Manejador para los botones de radio
    $('input[name="tipo_traslado"]').change(function() {
        const tipoSeleccionado = $(this).val();
        cargarHistorialTraslados(tipoSeleccionado);
    });
});