$(document).ready(function() {
    
    // --- Función para construir los Dropdowns ---
    function construirSelect(items, valorDefault = '') {
        let html = '';
        items.forEach(item => {
            html += `<option value="${item.id}" ${item.id == valorDefault ? 'selected' : ''}>${item.nombre}</option>`;
        });
        return html;
    }

    // Función central para cargar productos (búsqueda y paginación)
    function cargarProductos(pagina = 1, termino = '') {
        const tablaResultados = $('#tabla_resultados_traslado');
        const contenedorPaginacion = $('#contenedor-paginacion-traslado');

        $.ajax({
            type: 'POST',
            url: 'php/buscar_producto_traslado.php', 
            data: { 
                pagina: pagina, 
                termino: termino,
                // Asegúrate que AppData está definido ANTES de este script
                sucursales: AppData.sucursales,
                usuariosEnvian: AppData.usuariosEnvian
            },
            dataType: 'json',
            beforeSend: function() {
                // Colspan 7
                tablaResultados.html("<tr><td colspan='7' class='text-center'><div class='spinner-border spinner-border-sm'></div> Cargando...</td></tr>");
                contenedorPaginacion.empty();
            },
            success: function(response) {
                // Colspan 7
                tablaResultados.html(response.tabla || "<tr><td colspan='7' class='text-center'>No hay resultados.</td></tr>");
                contenedorPaginacion.html(response.paginacion);
            },
            error: function() {
                // Colspan 7
                tablaResultados.html("<tr><td colspan='7' class='text-center text-danger'>Error de conexión al servidor.</td></tr>");
            }
        });
    }

    // Carga inicial de productos
    cargarProductos();

    // Debounce para la búsqueda
    let typingTimer;
    $('#caja_busqueda_traslado').on('keyup', function() {
        clearTimeout(typingTimer);
        const terminoDeBusqueda = $(this).val();
        typingTimer = setTimeout(() => cargarProductos(1, terminoDeBusqueda), 500);
    });

    // Click en un enlace de paginación
    $('body').on('click', '.page-link-traslado', function(e) {
        e.preventDefault();
        const pagina = $(this).data('pagina');
        if (pagina) {
            cargarProductos(pagina, $('#caja_busqueda_traslado').val());
        }
    });
    
    // Click en el botón "Trasladar"
    $('body').on('click', '.btn-trasladar', function() {
        let boton = $(this);
        let fila = boton.closest('tr');
        
        let producto_id = boton.data('id');
        let cantidad = fila.find('input[name="cantidad"]').val();
        let presentacion = fila.find('select[name="presentacion"]').val();
        let sefactura = fila.find('input[name="sefactura"]').is(':checked') ? 1 : 0;
        let sucursal_destino_id = fila.find('select[name="sucursal_destino"]').val();
        let usuario_envia_id = fila.find('select[name="usuario_envia"]').val();

        if (!cantidad || cantidad <= 0) {
            mostrarNotificacion('Error: La cantidad debe ser un número mayor a cero.', 'danger');
            return;
        }
        if (!sucursal_destino_id || !usuario_envia_id) {
            mostrarNotificacion('Error: Debe seleccionar destino y quién envía.', 'danger');
            return;
        }

        $.ajax({
            type: 'POST',
            url: 'php/guardar_traslado.php',
            data: {
                producto_id: producto_id,
                cantidad: cantidad,
                presentacion: presentacion,
                sefactura: sefactura,
                sucursal_destino_id: sucursal_destino_id,
                usuario_envia_id: usuario_envia_id
            },
            dataType: 'json',
            beforeSend: () => boton.prop('disabled', true).html('<span class="spinner-border spinner-border-sm"></span>'),
            success: function(response) {
                if(response.status === 'success') {
                    fila.addClass('table-info'); 
                    fila.find('input, select, button').prop('disabled', true);
                    boton.removeClass('btn-info').addClass('btn-secondary').text('Hecho');
                    mostrarNotificacion(response.message, 'success');
                } else {
                    mostrarNotificacion('Error: ' + response.message, 'danger');
                    boton.prop('disabled', false).text('Trasladar');
                }
            },
            error: () => {
                mostrarNotificacion('Error de conexión al guardar.', 'danger');
                boton.prop('disabled', false).text('Trasladar');
            }
        });
    });

    // Función para mostrar notificaciones
    function mostrarNotificacion(mensaje, tipo = 'success') {
        const alerta = $('#alerta-notificacion');
        alerta.removeClass('alert-success alert-danger').addClass(`alert-${tipo}`);
        alerta.text(mensaje).removeClass('d-none');
        setTimeout(() => alerta.addClass('d-none'), 4000);
    }
});